/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.simsharing;

import edu.colorado.phet.common.phetcommon.util.IProguardKeepClass;
import edu.colorado.phet.gravityandorbits.model.Body;
import edu.colorado.phet.gravityandorbits.simsharing.VectorState;

public class PersistentBodyState
implements IProguardKeepClass {
    private VectorState position;
    private VectorState velocity;
    private VectorState acceleration;
    private VectorState force;
    private double mass;
    private double diameter;
    private boolean userControlled;
    private boolean collided;

    public PersistentBodyState() {
    }

    public PersistentBodyState(Body body) {
        this.position = new VectorState(body.getPosition());
        this.velocity = new VectorState(body.getVelocity());
        this.acceleration = new VectorState(body.getAcceleration());
        this.force = new VectorState(body.getForceProperty().get());
        this.mass = body.getMass();
        this.diameter = body.getDiameter();
        this.userControlled = body.isUserControlled();
        this.collided = body.getCollidedProperty().get();
    }

    public void apply(Body body) {
        body.setPosition(this.position.getX(), this.position.getY());
        body.setVelocity(this.velocity.toImmutableVector2D());
        body.setAcceleration(this.acceleration.toImmutableVector2D());
        body.setForce(this.force.toImmutableVector2D());
        body.setMass(this.mass);
        body.setDiameter(this.diameter);
        body.setUserControlled(this.userControlled);
        body.getCollidedProperty().set(this.collided);
    }

    public VectorState getPosition() {
        return this.position;
    }

    public void setPosition(VectorState vectorState) {
        this.position = vectorState;
    }

    public VectorState getVelocity() {
        return this.velocity;
    }

    public void setVelocity(VectorState vectorState) {
        this.velocity = vectorState;
    }

    public VectorState getAcceleration() {
        return this.acceleration;
    }

    public void setAcceleration(VectorState vectorState) {
        this.acceleration = vectorState;
    }

    public VectorState getForce() {
        return this.force;
    }

    public void setForce(VectorState vectorState) {
        this.force = vectorState;
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double d) {
        this.mass = d;
    }

    public double getDiameter() {
        return this.diameter;
    }

    public void setDiameter(double d) {
        this.diameter = d;
    }

    public boolean isUserControlled() {
        return this.userControlled;
    }

    public void setUserControlled(boolean bl) {
        this.userControlled = bl;
    }

    public boolean isCollided() {
        return this.collided;
    }

    public void setCollided(boolean bl) {
        this.collided = bl;
    }
}

