/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.simsharing;

import edu.colorado.phet.common.phetcommon.util.IProguardKeepClass;
import edu.colorado.phet.gravityandorbits.module.GravityAndOrbitsMode;
import edu.colorado.phet.gravityandorbits.module.GravityAndOrbitsModule;
import edu.colorado.phet.gravityandorbits.simsharing.GravityAndOrbitsModeState;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GravityAndOrbitsModuleState
implements IProguardKeepClass {
    private boolean showGravityForce;
    private boolean showPaths;
    private boolean showVelocity;
    private boolean showMass;
    private boolean showGrid;
    private boolean gravityEnabled;
    private ArrayList<GravityAndOrbitsModeState> modeStates;
    private int selectedMode;
    private boolean showMeasuringTape;

    public GravityAndOrbitsModuleState() {
    }

    public GravityAndOrbitsModuleState(GravityAndOrbitsModule gravityAndOrbitsModule) {
        this.showGravityForce = (Boolean)gravityAndOrbitsModule.showGravityForceProperty.get();
        this.showPaths = gravityAndOrbitsModule.showPathProperty.get();
        this.showVelocity = (Boolean)gravityAndOrbitsModule.showVelocityProperty.get();
        this.showMass = gravityAndOrbitsModule.showMassProperty.get();
        this.gravityEnabled = gravityAndOrbitsModule.gravityEnabledProperty.get();
        this.modeStates = new ArrayList();
        for (GravityAndOrbitsMode gravityAndOrbitsMode : gravityAndOrbitsModule.getModes()) {
            this.modeStates.add(new GravityAndOrbitsModeState(gravityAndOrbitsMode));
        }
        this.selectedMode = gravityAndOrbitsModule.getModeIndex();
        this.showGrid = gravityAndOrbitsModule.showGridProperty.get();
        this.showMeasuringTape = gravityAndOrbitsModule.measuringTapeVisibleProperty.get();
    }

    public void apply(GravityAndOrbitsModule gravityAndOrbitsModule) {
        gravityAndOrbitsModule.showGravityForceProperty.set(this.showGravityForce);
        gravityAndOrbitsModule.showPathProperty.set(this.showPaths);
        gravityAndOrbitsModule.showVelocityProperty.set(this.showVelocity);
        gravityAndOrbitsModule.showMassProperty.set(this.showMass);
        gravityAndOrbitsModule.gravityEnabledProperty.set(this.gravityEnabled);
        for (int i = 0; i < this.modeStates.size(); ++i) {
            this.modeStates.get(i).apply(gravityAndOrbitsModule.getModes().get(i));
        }
        gravityAndOrbitsModule.setModeIndex(this.selectedMode);
        gravityAndOrbitsModule.showGridProperty.set(this.showGrid);
        gravityAndOrbitsModule.measuringTapeVisibleProperty.set(this.showMeasuringTape);
    }

    public String toString() {
        return "GravityAndOrbitsModuleState{showGravityForce=" + this.showGravityForce + ", showPaths=" + this.showPaths + ", showVelocity=" + this.showVelocity + ", showMass=" + this.showMass + ", gravityEnabled=" + this.gravityEnabled + ", modelStates=" + this.modeStates + '}';
    }

    public boolean isShowGravityForce() {
        return this.showGravityForce;
    }

    public void setShowGravityForce(boolean bl) {
        this.showGravityForce = bl;
    }

    public boolean isShowPaths() {
        return this.showPaths;
    }

    public void setShowPaths(boolean bl) {
        this.showPaths = bl;
    }

    public boolean isShowVelocity() {
        return this.showVelocity;
    }

    public void setShowVelocity(boolean bl) {
        this.showVelocity = bl;
    }

    public boolean isShowMass() {
        return this.showMass;
    }

    public void setShowMass(boolean bl) {
        this.showMass = bl;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean bl) {
        this.showGrid = bl;
    }

    public boolean isGravityEnabled() {
        return this.gravityEnabled;
    }

    public void setGravityEnabled(boolean bl) {
        this.gravityEnabled = bl;
    }

    public ArrayList<GravityAndOrbitsModeState> getModeStates() {
        return this.modeStates;
    }

    public void setModeStates(ArrayList<GravityAndOrbitsModeState> arrayList) {
        this.modeStates = arrayList;
    }

    public int getSelectedMode() {
        return this.selectedMode;
    }

    public void setSelectedMode(int n) {
        this.selectedMode = n;
    }

    public boolean isShowMeasuringTape() {
        return this.showMeasuringTape;
    }

    public void setShowMeasuringTape(boolean bl) {
        this.showMeasuringTape = bl;
    }
}

