/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.simsharing;

import edu.colorado.phet.common.phetcommon.util.IProguardKeepClass;
import edu.colorado.phet.gravityandorbits.model.Body;
import edu.colorado.phet.gravityandorbits.model.GravityAndOrbitsModel;
import edu.colorado.phet.gravityandorbits.simsharing.PersistentBodyState;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GravityAndOrbitsModelState
implements IProguardKeepClass {
    private boolean paused;
    private double simulationTime;
    private ArrayList<PersistentBodyState> persistentBodyStates;

    public GravityAndOrbitsModelState() {
    }

    public GravityAndOrbitsModelState(GravityAndOrbitsModel gravityAndOrbitsModel) {
        this.simulationTime = gravityAndOrbitsModel.getClock().getSimulationTime();
        this.paused = gravityAndOrbitsModel.getClock().isPaused();
        this.persistentBodyStates = new ArrayList();
        for (Body body : gravityAndOrbitsModel.getBodies()) {
            this.persistentBodyStates.add(new PersistentBodyState(body));
        }
    }

    public void apply(GravityAndOrbitsModel gravityAndOrbitsModel) {
        gravityAndOrbitsModel.getClock().setSimulationTime(this.simulationTime);
        gravityAndOrbitsModel.getClock().setPaused(this.paused);
        for (int i = 0; i < this.persistentBodyStates.size(); ++i) {
            this.persistentBodyStates.get(i).apply(gravityAndOrbitsModel.getBodies().get(i));
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    public double getSimulationTime() {
        return this.simulationTime;
    }

    public void setSimulationTime(double d) {
        this.simulationTime = d;
    }

    public ArrayList<PersistentBodyState> getPersistentBodyStates() {
        return this.persistentBodyStates;
    }

    public void setPersistentBodyStates(ArrayList<PersistentBodyState> arrayList) {
        this.persistentBodyStates = arrayList;
    }
}

