/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.simsharing;

import edu.colorado.phet.common.phetcommon.util.IProguardKeepClass;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.gravityandorbits.GravityAndOrbitsApplication;
import edu.colorado.phet.gravityandorbits.simsharing.GravityAndOrbitsModuleState;
import edu.colorado.phet.gravityandorbits.simsharing.ImageFactory;
import edu.colorado.phet.gravityandorbits.simsharing.SerializableBufferedImage;
import java.awt.Dimension;

public class GravityAndOrbitsApplicationState
implements IProguardKeepClass {
    private GravityAndOrbitsModuleState introState;
    private GravityAndOrbitsModuleState toScaleState;
    private long timestamp;
    private int frameWidth;
    private int frameHeight;
    private byte[] thumbnail;
    private int activeModule;

    public GravityAndOrbitsApplicationState(GravityAndOrbitsApplication gravityAndOrbitsApplication, ImageFactory imageFactory) {
        PhetFrame phetFrame = gravityAndOrbitsApplication.getPhetFrame();
        this.introState = new GravityAndOrbitsModuleState(gravityAndOrbitsApplication.getIntro());
        this.toScaleState = new GravityAndOrbitsModuleState(gravityAndOrbitsApplication.getToScale());
        this.timestamp = System.currentTimeMillis();
        this.frameWidth = phetFrame.getWidth();
        this.frameHeight = phetFrame.getHeight();
        this.thumbnail = new SerializableBufferedImage(imageFactory.getThumbnail(phetFrame, 200)).getByteImage();
        this.activeModule = gravityAndOrbitsApplication.indexOf(gravityAndOrbitsApplication.getActiveModule());
    }

    public byte[] getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(byte[] byArray) {
        this.thumbnail = byArray;
    }

    public GravityAndOrbitsApplicationState() {
    }

    public void apply(GravityAndOrbitsApplication gravityAndOrbitsApplication) {
        gravityAndOrbitsApplication.setActiveModule(this.activeModule);
        this.introState.apply(gravityAndOrbitsApplication.getIntro());
        this.toScaleState.apply(gravityAndOrbitsApplication.getToScale());
        if (gravityAndOrbitsApplication.getPhetFrame().getSize().width != this.frameWidth || gravityAndOrbitsApplication.getPhetFrame().getSize().height != this.frameHeight) {
            gravityAndOrbitsApplication.getPhetFrame().setSize(new Dimension(this.frameWidth, this.frameHeight));
        }
    }

    public String toString() {
        return "GravityAndOrbitsApplicationState{, timestamp=" + this.timestamp + '}';
    }

    public GravityAndOrbitsModuleState getIntroState() {
        return this.introState;
    }

    public void setIntroState(GravityAndOrbitsModuleState gravityAndOrbitsModuleState) {
        this.introState = gravityAndOrbitsModuleState;
    }

    public GravityAndOrbitsModuleState getToScaleState() {
        return this.toScaleState;
    }

    public void setToScaleState(GravityAndOrbitsModuleState gravityAndOrbitsModuleState) {
        this.toScaleState = gravityAndOrbitsModuleState;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    public int getFrameWidth() {
        return this.frameWidth;
    }

    public void setFrameWidth(int n) {
        this.frameWidth = n;
    }

    public int getFrameHeight() {
        return this.frameHeight;
    }

    public void setFrameHeight(int n) {
        this.frameHeight = n;
    }

    public int getActiveModule() {
        return this.activeModule;
    }

    public void setActiveModule(int n) {
        this.activeModule = n;
    }
}

