/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.module;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.Function2;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.gravityandorbits.GAOStrings;
import edu.colorado.phet.gravityandorbits.GravityAndOrbitsApplication;
import edu.colorado.phet.gravityandorbits.model.Body;
import edu.colorado.phet.gravityandorbits.model.BodyState;
import edu.colorado.phet.gravityandorbits.model.GravityAndOrbitsModel;
import edu.colorado.phet.gravityandorbits.module.BodyConfiguration;
import edu.colorado.phet.gravityandorbits.module.GravityAndOrbitsMode;
import edu.colorado.phet.gravityandorbits.module.ModeConfig;
import edu.colorado.phet.gravityandorbits.module.ModeListParameterList;
import edu.colorado.phet.gravityandorbits.view.BodyNode;
import edu.colorado.phet.gravityandorbits.view.BodyRenderer;
import edu.colorado.phet.gravityandorbits.view.EarthMassReadoutNode;
import edu.colorado.phet.gravityandorbits.view.MeasuringTape;
import edu.colorado.phet.gravityandorbits.view.SpaceStationMassReadoutNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModeList
extends ArrayList<GravityAndOrbitsMode> {
    private ModeListParameterList p;
    private final Function2<Body, Double, BodyRenderer> SUN_RENDERER = new Function2<Body, Double, BodyRenderer>(){

        @Override
        public BodyRenderer apply(Body body, Double d) {
            return new BodyRenderer.SphereRenderer(body, d);
        }
    };
    private static final Function1<Double, String> formatMinutes = new Function1<Double, String>(){
        final double SECONDS_PER_MINUTE = 60.0;

        @Override
        public String apply(Double d) {
            int n = (int)(d / 60.0);
            String string = n == 1 ? GAOStrings.EARTH_MINUTE : GAOStrings.EARTH_MINUTES;
            return MessageFormat.format(GAOStrings.PATTERN_VALUE_UNITS, n, string);
        }
    };

    public ModeList(ModeListParameterList modeListParameterList, final SunEarthModeConfig sunEarthModeConfig, final SunEarthMoonModeConfig sunEarthMoonModeConfig, final EarthMoonModeConfig earthMoonModeConfig, final EarthSpaceStationModeConfig earthSpaceStationModeConfig) {
        sunEarthModeConfig.center();
        sunEarthMoonModeConfig.center();
        earthMoonModeConfig.center();
        earthSpaceStationModeConfig.center();
        this.p = modeListParameterList;
        Function2<BodyNode, Property<Boolean>, PNode> function2 = new Function2<BodyNode, Property<Boolean>, PNode>(){

            @Override
            public PNode apply(BodyNode bodyNode, Property<Boolean> property) {
                return new EarthMassReadoutNode(bodyNode, property);
            }
        };
        int n = 31536000;
        this.add(new GravityAndOrbitsMode(sunEarthModeConfig.forceScale, false, sunEarthModeConfig.dt, ModeList.scaledDays(sunEarthModeConfig.timeScale), this.createIconImage(true, true, false, false), n, 4480000.0, function2, sunEarthModeConfig.initialMeasuringTapeLocation, sunEarthModeConfig.zoom, new ImmutableVector2D(0.0, 0.0), sunEarthModeConfig.earth.x / 2.0, new Point2D.Double(0.0, 0.0), modeListParameterList){
            {
                super(d, bl, d2, function1, image, d3, d4, function2, double_, d5, immutableVector2D, d6, double_2, modeListParameterList);
                this.addBody(new Sun(this.getMaxPathLength(), sunEarthModeConfig.sun));
                this.addBody(new Earth(this.getMaxPathLength(), sunEarthModeConfig.earth));
            }
        });
        this.add(new GravityAndOrbitsMode(sunEarthMoonModeConfig.forceScale, false, sunEarthMoonModeConfig.dt, ModeList.scaledDays(sunEarthMoonModeConfig.timeScale), this.createIconImage(true, true, true, false), n, 4480000.0, function2, sunEarthMoonModeConfig.initialMeasuringTapeLocation, sunEarthMoonModeConfig.zoom, new ImmutableVector2D(0.0, 0.0), sunEarthMoonModeConfig.earth.x / 2.0, new Point2D.Double(0.0, 0.0), modeListParameterList){
            {
                super(d, bl, d2, function1, image, d3, d4, function2, double_, d5, immutableVector2D, d6, double_2, modeListParameterList);
                this.addBody(new Sun(this.getMaxPathLength(), sunEarthMoonModeConfig.sun));
                this.addBody(new Earth(this.getMaxPathLength(), sunEarthMoonModeConfig.earth));
                this.addBody(new Moon(false, this.getMaxPathLength(), false, sunEarthMoonModeConfig.moon));
            }
        });
        int n2 = 2419200;
        this.add(new GravityAndOrbitsMode(earthMoonModeConfig.forceScale, false, 28800.0, ModeList.scaledDays(1.0), this.createIconImage(false, true, true, false), n2, 268800.0, function2, earthMoonModeConfig.initialMeasuringTapeLocation, earthMoonModeConfig.zoom, new ImmutableVector2D(earthMoonModeConfig.earth.x, 0.0), earthMoonModeConfig.moon.y / 2.0, new Point2D.Double(earthMoonModeConfig.earth.x, 0.0), modeListParameterList){
            {
                super(d, bl, d2, function1, image, d3, d4, function2, double_, d5, immutableVector2D, d6, double_2, modeListParameterList);
                this.addBody(new Earth(this.getMaxPathLength(), earthMoonModeConfig.earth));
                this.addBody(new Moon(true, this.getMaxPathLength(), true, earthMoonModeConfig.moon));
            }
        });
        Function2<BodyNode, Property<Boolean>, PNode> function22 = new Function2<BodyNode, Property<Boolean>, PNode>(){

            @Override
            public PNode apply(BodyNode bodyNode, Property<Boolean> property) {
                return new SpaceStationMassReadoutNode(bodyNode, property);
            }
        };
        this.add(new GravityAndOrbitsMode(earthSpaceStationModeConfig.forceScale, false, 77.75999999999999, formatMinutes, this.createIconImage(false, true, false, true), 5400.0, 448.0, function22, earthSpaceStationModeConfig.initialMeasuringTapeLocation, earthSpaceStationModeConfig.zoom, new ImmutableVector2D(earthSpaceStationModeConfig.earth.x, 0.0), earthSpaceStationModeConfig.spaceStation.x - earthSpaceStationModeConfig.earth.x, new Point2D.Double(earthSpaceStationModeConfig.earth.x, 0.0), modeListParameterList){
            {
                super(d, bl, d2, function1, image, d3, d4, function2, double_, d5, immutableVector2D, d6, double_2, modeListParameterList);
                this.addBody(new Earth(this.getMaxPathLength(), earthSpaceStationModeConfig.earth));
                this.addBody(new SpaceStation(earthSpaceStationModeConfig, this.getMaxPathLength()));
            }
        });
    }

    private Image createIconImage(final boolean bl, final boolean bl2, final boolean bl3, final boolean bl4) {
        return new PNode(){
            {
                int n = 5;
                this.addChild(new PhetPPath((Shape)new Rectangle2D.Double(20.0, 0.0, 1.0, 1.0), (Paint)new Color(0, 0, 0, 0)));
                this.addIcon(n, new PImage(new BodyRenderer.SphereRenderer(Color.yellow, Color.white, 30.0).toImage()), bl);
                this.addIcon(n, new PImage(BufferedImageUtils.multiScaleToWidth(GravityAndOrbitsApplication.RESOURCES.getImage("earth_satellite.gif"), 30)), bl2);
                this.addIcon(n, new PImage(BufferedImageUtils.multiScaleToWidth(GravityAndOrbitsApplication.RESOURCES.getImage("moon.png"), 30)), bl3);
                this.addIcon(n, new PImage(BufferedImageUtils.multiScaleToWidth(GravityAndOrbitsApplication.RESOURCES.getImage("space-station.png"), 30)), bl4);
            }

            private void addIcon(int n, PNode pNode, boolean bl5) {
                this.addChild(pNode);
                pNode.setOffset(this.getFullBounds().getMaxX() + (double)n + pNode.getFullBounds().getWidth() / 2.0, 0.0);
                pNode.setVisible(bl5);
            }
        }.toImage();
    }

    public static Function2<Body, Double, BodyRenderer> getImageRenderer(final String string) {
        return new Function2<Body, Double, BodyRenderer>(){

            @Override
            public BodyRenderer apply(Body body, Double d) {
                return new BodyRenderer.ImageRenderer(body, d, string);
            }
        };
    }

    public static Function2<Body, Double, BodyRenderer> getRenderer(final String string, final double d) {
        return new Function2<Body, Double, BodyRenderer>(){

            @Override
            public BodyRenderer apply(Body body, Double d2) {
                return new BodyRenderer.SwitchableBodyRenderer(body, d, new BodyRenderer.ImageRenderer(body, d2, string), new BodyRenderer.SphereRenderer(body, d2));
            }
        };
    }

    public static Function1<Double, String> scaledDays(final double d) {
        return new Function1<Double, String>(){

            @Override
            public String apply(Double d2) {
                int n = (int)(d2 / 86400.0 * d);
                String string = n == 1 ? GAOStrings.EARTH_DAY : GAOStrings.EARTH_DAYS;
                return MessageFormat.format(GAOStrings.PATTERN_VALUE_UNITS, n, string);
            }
        };
    }

    public class Earth
    extends Body {
        public Earth(int n, BodyConfiguration bodyConfiguration) {
            super(GAOStrings.PLANET, bodyConfiguration.x, bodyConfiguration.y, bodyConfiguration.radius * 2.0, bodyConfiguration.vx, bodyConfiguration.vy, bodyConfiguration.mass, Color.gray, Color.lightGray, ModeList.getRenderer("earth_satellite.gif", bodyConfiguration.mass), -0.7853981633974483, true, n, true, bodyConfiguration.mass, GAOStrings.EARTH, ((ModeList)ModeList.this).p.playButtonPressed, ((ModeList)ModeList.this).p.stepping, ((ModeList)ModeList.this).p.rewinding, bodyConfiguration.fixed);
        }
    }

    public static class EarthMoonModeConfig
    extends ModeConfig {
        BodyConfiguration earth = new BodyConfiguration(5.9736E24, 6371000.0, 1.4709829E11, 0.0, 0.0, 0.0);
        BodyConfiguration moon = new BodyConfiguration(7.3477E22, 1737100.0, 1.4709829E11, 3.9137E8, -1010.0, 0.0);

        public EarthMoonModeConfig() {
            super(400.0);
            this.initialMeasuringTapeLocation = new Line2D.Double(this.earth.x + this.earth.radius * 2.0, -this.moon.y * 0.7, this.earth.x + this.earth.radius * 2.0 + MeasuringTape.milesToMeters(100000.0), -this.moon.y * 0.7);
            this.forceScale = 6.603591426916394E-13;
        }

        protected BodyConfiguration[] getBodies() {
            return new BodyConfiguration[]{this.earth, this.moon};
        }
    }

    public static class EarthSpaceStationModeConfig
    extends ModeConfig {
        BodyConfiguration earth = new BodyConfiguration(5.9736E24, 6371000.0, 0.0, 0.0, 0.0, 0.0);
        BodyConfiguration spaceStation = new BodyConfiguration(369914.0, 109.0, 6718109.0, 0.0, 0.0, 7706.0);

        public EarthSpaceStationModeConfig() {
            super(21600.0);
            this.initialMeasuringTapeLocation = new Line2D.Double(3162119.0, 7680496.0, 6439098.0, 7680496.0);
            this.forceScale = 0.44023942846109293;
        }

        protected BodyConfiguration[] getBodies() {
            return new BodyConfiguration[]{this.earth, this.spaceStation};
        }
    }

    class Moon
    extends Body {
        public Moon(boolean bl, int n, boolean bl2, BodyConfiguration bodyConfiguration) {
            super(GAOStrings.MOON, bodyConfiguration.x, bodyConfiguration.y, bodyConfiguration.radius * 2.0, bodyConfiguration.vx, bodyConfiguration.vy, bodyConfiguration.mass, Color.magenta, Color.white, ModeList.getRenderer("moon.png", bodyConfiguration.mass), -2.356194490192345, bl, n, bl2, bodyConfiguration.mass, GAOStrings.OUR_MOON, ((ModeList)ModeList.this).p.playButtonPressed, ((ModeList)ModeList.this).p.stepping, ((ModeList)ModeList.this).p.rewinding, bodyConfiguration.fixed);
        }

        protected void doReturnBody(GravityAndOrbitsModel gravityAndOrbitsModel) {
            super.doReturnBody(gravityAndOrbitsModel);
            Body body = gravityAndOrbitsModel.getBody("Planet");
            if (body == null) {
                throw new RuntimeException("Couldn't find planet.");
            }
            ImmutableVector2D immutableVector2D = this.getPositionProperty().getInitialValue().minus(body.getPositionProperty().getInitialValue());
            this.getPositionProperty().set(body.getPosition().plus(immutableVector2D));
            ImmutableVector2D immutableVector2D2 = this.getVelocityProperty().getInitialValue().minus(body.getVelocityProperty().getInitialValue());
            this.getVelocityProperty().set(body.getVelocity().plus(immutableVector2D2));
        }
    }

    class SpaceStation
    extends Body {
        public SpaceStation(EarthSpaceStationModeConfig earthSpaceStationModeConfig, int n) {
            super(GAOStrings.SATELLITE, earthSpaceStationModeConfig.spaceStation.x, earthSpaceStationModeConfig.spaceStation.y, earthSpaceStationModeConfig.spaceStation.radius * 2000.0, earthSpaceStationModeConfig.spaceStation.vx, earthSpaceStationModeConfig.spaceStation.vy, earthSpaceStationModeConfig.spaceStation.mass, Color.gray, Color.white, ModeList.getImageRenderer("space-station.png"), -0.7853981633974483, true, n, true, earthSpaceStationModeConfig.spaceStation.mass, GAOStrings.SPACE_STATION, ((ModeList)ModeList.this).p.playButtonPressed, ((ModeList)ModeList.this).p.stepping, ((ModeList)ModeList.this).p.rewinding, earthSpaceStationModeConfig.spaceStation.fixed);
        }
    }

    public class Sun
    extends Body {
        private final BodyConfiguration body;

        public Sun(int n, BodyConfiguration bodyConfiguration) {
            super(GAOStrings.STAR, bodyConfiguration.x, bodyConfiguration.y, bodyConfiguration.radius * 2.0, bodyConfiguration.vx, bodyConfiguration.vy, bodyConfiguration.mass, Color.yellow, Color.white, ModeList.this.SUN_RENDERER, -0.7853981633974483, true, n, true, bodyConfiguration.mass, GAOStrings.OUR_SUN, ((ModeList)ModeList.this).p.playButtonPressed, ((ModeList)ModeList.this).p.stepping, ((ModeList)ModeList.this).p.rewinding, bodyConfiguration.fixed);
            this.body = bodyConfiguration;
        }

        public void updateBodyStateFromModel(BodyState bodyState) {
            ImmutableVector2D immutableVector2D = this.getPosition();
            super.updateBodyStateFromModel(bodyState);
            if (this.body.fixed) {
                this.setPosition(immutableVector2D.getX(), immutableVector2D.getY());
                this.setVelocity(new ImmutableVector2D());
            }
        }
    }

    public static class SunEarthModeConfig
    extends ModeConfig {
        BodyConfiguration sun = new BodyConfiguration(1.989E30, 6.955E8, 0.0, 0.0, 0.0, 0.0);
        BodyConfiguration earth = new BodyConfiguration(5.9736E24, 6371000.0, 1.4709829E11, 0.0, 0.0, 30300.0);
        double timeScale = 1.0;

        public SunEarthModeConfig() {
            super(1.25);
            this.initialMeasuringTapeLocation = new Line2D.Double((this.sun.x + this.earth.x) / 3.0, -this.earth.x / 2.0, (this.sun.x + this.earth.x) / 3.0 + MeasuringTape.milesToMeters(5.0E7), -this.earth.x / 2.0);
            this.forceScale = 1.7609577138443715E-12;
        }

        protected BodyConfiguration[] getBodies() {
            return new BodyConfiguration[]{this.sun, this.earth};
        }
    }

    public static class SunEarthMoonModeConfig
    extends ModeConfig {
        BodyConfiguration sun = new BodyConfiguration(1.989E30, 6.955E8, 0.0, 0.0, 0.0, 0.0);
        BodyConfiguration earth = new BodyConfiguration(5.9736E24, 6371000.0, 1.4709829E11, 0.0, 0.0, 30300.0);
        BodyConfiguration moon = new BodyConfiguration(7.3477E22, 1737100.0, 1.4709829E11, 3.9137E8, -1010.0, 30300.0);
        double timeScale = 1.0;

        public SunEarthMoonModeConfig() {
            super(1.25);
            this.initialMeasuringTapeLocation = new Line2D.Double((this.sun.x + this.earth.x) / 3.0, -this.earth.x / 2.0, (this.sun.x + this.earth.x) / 3.0 + MeasuringTape.milesToMeters(5.0E7), -this.earth.x / 2.0);
            this.forceScale = 1.7609577138443715E-12;
        }

        protected BodyConfiguration[] getBodies() {
            return new BodyConfiguration[]{this.sun, this.earth, this.moon};
        }
    }
}

