/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.module;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.gravityandorbits.module.BodyConfiguration;
import java.awt.geom.Line2D;

public abstract class ModeConfig {
    double zoom;
    double dt = 86400.0;
    protected double forceScale;
    public Line2D.Double initialMeasuringTapeLocation;

    public ModeConfig(double d) {
        this.zoom = d;
    }

    public void center() {
        ImmutableVector2D immutableVector2D = this.getTotalMomentum().times(-1.0 / this.getTotalMass());
        for (BodyConfiguration bodyConfiguration : this.getBodies()) {
            bodyConfiguration.vx += immutableVector2D.getX();
            bodyConfiguration.vy += immutableVector2D.getY();
        }
    }

    private ImmutableVector2D getTotalMomentum() {
        ImmutableVector2D immutableVector2D = new ImmutableVector2D();
        for (BodyConfiguration bodyConfiguration : this.getBodies()) {
            immutableVector2D = immutableVector2D.plus(bodyConfiguration.getMomentum());
        }
        return immutableVector2D;
    }

    private double getTotalMass() {
        double d = 0.0;
        for (BodyConfiguration bodyConfiguration : this.getBodies()) {
            d += bodyConfiguration.mass;
        }
        return d;
    }

    protected abstract BodyConfiguration[] getBodies();
}

