/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.module;

import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.gravityandorbits.module.GravityAndOrbitsMode;
import edu.colorado.phet.gravityandorbits.module.ModeListParameterList;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GravityAndOrbitsModule
extends PiccoloModule {
    public final BooleanProperty showGravityForceProperty = new BooleanProperty(false);
    public final Property<Boolean> showPathProperty = new Property<Boolean>(false);
    public final Property<Boolean> showGridProperty = new Property<Boolean>(false);
    public final BooleanProperty showVelocityProperty = new BooleanProperty(false);
    public final Property<Boolean> showMassProperty = new Property<Boolean>(false);
    public final Property<Boolean> playButtonPressed = new Property<Boolean>(false);
    public final Property<Double> timeSpeedScaleProperty = new Property<Double>(0.525);
    public final Property<Boolean> measuringTapeVisibleProperty = new Property<Boolean>(false);
    public final Property<Boolean> gravityEnabledProperty = new Property<Boolean>(true);
    public final Property<Boolean> stepping = new Property<Boolean>(false);
    public final Property<Boolean> rewinding = new Property<Boolean>(false);
    public final Property<GravityAndOrbitsMode> modeProperty;
    public final Property<Boolean> whiteBackgroundProperty;
    public final boolean showMeasuringTape;
    private final ArrayList<GravityAndOrbitsMode> modes;
    public final boolean showMassCheckBox;

    public GravityAndOrbitsModule(PhetFrame phetFrame, Property<Boolean> property, String string, boolean bl, Function1<ModeListParameterList, ArrayList<GravityAndOrbitsMode>> function1, int n, boolean bl2) {
        super(string, new ConstantDtClock(30, 1.0));
        this.showMassCheckBox = bl2;
        this.modes = function1.apply(new ModeListParameterList(this.playButtonPressed, this.gravityEnabledProperty, this.stepping, this.rewinding, this.timeSpeedScaleProperty));
        this.modeProperty = new Property<GravityAndOrbitsMode>(this.modes.get(n));
        this.whiteBackgroundProperty = property;
        this.showMeasuringTape = bl;
        this.getModulePanel().setLogoPanel(null);
        for (GravityAndOrbitsMode gravityAndOrbitsMode : this.modes) {
            gravityAndOrbitsMode.init(this);
        }
        this.setSimulationPanel(this.getMode().getCanvas());
        this.modeProperty.addObserver(new SimpleObserver(){

            public void update() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GravityAndOrbitsModule.this.setSimulationPanel(GravityAndOrbitsModule.this.getMode().getCanvas());
                    }
                });
                GravityAndOrbitsModule.this.updateActiveModule();
            }
        });
        this.setClockControlPanel(null);
        this.reset();
    }

    public int getModeIndex() {
        return this.modes.indexOf(this.getMode());
    }

    private GravityAndOrbitsMode getMode() {
        return this.modeProperty.get();
    }

    public ArrayList<GravityAndOrbitsMode> getModes() {
        return new ArrayList<GravityAndOrbitsMode>(this.modes);
    }

    private void updateActiveModule() {
        for (GravityAndOrbitsMode gravityAndOrbitsMode : this.modes) {
            gravityAndOrbitsMode.active.set(gravityAndOrbitsMode == this.getMode());
        }
    }

    @Override
    public void reset() {
        for (GravityAndOrbitsMode gravityAndOrbitsMode : this.modes) {
            gravityAndOrbitsMode.reset();
        }
        this.showGravityForceProperty.reset();
        this.showPathProperty.reset();
        this.showGridProperty.reset();
        this.showVelocityProperty.reset();
        this.showMassProperty.reset();
        this.playButtonPressed.reset();
        this.timeSpeedScaleProperty.reset();
        this.measuringTapeVisibleProperty.reset();
        this.gravityEnabledProperty.reset();
        this.stepping.reset();
        this.rewinding.reset();
        this.modeProperty.reset();
    }

    public void setModeIndex(int n) {
        this.modeProperty.set(this.modes.get(n));
    }
}

