/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.module;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.Function2;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.gravityandorbits.controlpanel.GAORadioButton;
import edu.colorado.phet.gravityandorbits.controlpanel.GravityAndOrbitsControlPanel;
import edu.colorado.phet.gravityandorbits.model.Body;
import edu.colorado.phet.gravityandorbits.model.GravityAndOrbitsClock;
import edu.colorado.phet.gravityandorbits.model.GravityAndOrbitsModel;
import edu.colorado.phet.gravityandorbits.module.GravityAndOrbitsModule;
import edu.colorado.phet.gravityandorbits.module.ModeListParameterList;
import edu.colorado.phet.gravityandorbits.view.BodyNode;
import edu.colorado.phet.gravityandorbits.view.GravityAndOrbitsCanvas;
import edu.umd.cs.piccolo.PNode;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GravityAndOrbitsMode {
    private final GravityAndOrbitsModel model;
    private GravityAndOrbitsCanvas canvas;
    private final double forceScale;
    public final Property<Boolean> active;
    private final Function1<Double, String> timeFormatter;
    private final Image iconImage;
    private final double defaultOrbitalPeriod;
    private final double dt;
    private final double velocityVectorScale;
    public final Function2<BodyNode, Property<Boolean>, PNode> massReadoutFactory;
    private final Property<Boolean> deviatedFromDefaults = new Property<Boolean>(false);
    private double rewindClockTime;
    private static final double PLAY_AREA_WIDTH = GravityAndOrbitsCanvas.STAGE_SIZE.width * 0.6;
    private static final double PLAY_AREA_HEIGHT = GravityAndOrbitsCanvas.STAGE_SIZE.height;
    private final double gridSpacing;
    private final Point2D.Double gridCenter;
    public final Property<ModelViewTransform> transform;
    public final Property<Boolean> rewinding;
    public final Property<Double> timeSpeedScaleProperty;
    public final Property<ImmutableVector2D> measuringTapeStartPoint;
    public final Property<ImmutableVector2D> measuringTapeEndPoint;
    public final Property<Double> zoomLevel = new Property<Double>(1.0);
    public final ModeListParameterList p;

    public GravityAndOrbitsMode(double d, boolean bl, double d2, Function1<Double, String> function1, Image image, double d3, double d4, Function2<BodyNode, Property<Boolean>, PNode> function2, Line2D.Double double_, final double d5, final ImmutableVector2D immutableVector2D, double d6, Point2D.Double double_2, final ModeListParameterList modeListParameterList) {
        this.dt = d2;
        this.p = modeListParameterList;
        this.forceScale = d;
        this.iconImage = image;
        this.defaultOrbitalPeriod = d3;
        this.velocityVectorScale = d4;
        this.gridSpacing = d6;
        this.gridCenter = double_2;
        this.rewinding = modeListParameterList.rewinding;
        this.timeSpeedScaleProperty = modeListParameterList.timeSpeedScale;
        this.active = new Property<Boolean>(bl);
        this.timeFormatter = function1;
        this.massReadoutFactory = function2;
        this.transform = new Property<ModelViewTransform>(this.createTransform(d5, immutableVector2D));
        this.zoomLevel.addObserver(new SimpleObserver(){

            public void update() {
                GravityAndOrbitsMode.this.transform.set(GravityAndOrbitsMode.this.createTransform(d5, immutableVector2D));
            }
        });
        this.model = new GravityAndOrbitsModel(new GravityAndOrbitsClock(d2, modeListParameterList.stepping, this.timeSpeedScaleProperty), modeListParameterList.gravityEnabled);
        this.rewindClockTime = 0.0;
        this.getClock().addClockListener(new ClockAdapter(){

            public void clockPaused(ClockEvent clockEvent) {
                GravityAndOrbitsMode.this.rewindClockTime = clockEvent.getSimulationTime();
            }
        });
        new RichSimpleObserver(){

            public void update() {
                GravityAndOrbitsMode.this.model.getClock().setRunning(modeListParameterList.playButtonPressed.get() != false && GravityAndOrbitsMode.this.active.get() != false);
            }
        }.observe(modeListParameterList.playButtonPressed, this.active);
        this.measuringTapeStartPoint = new Property<ImmutableVector2D>(new ImmutableVector2D(double_.getP1()));
        this.measuringTapeEndPoint = new Property<ImmutableVector2D>(new ImmutableVector2D(double_.getP2()));
    }

    private ModelViewTransform createTransform(double d, ImmutableVector2D immutableVector2D) {
        Rectangle2D.Double double_ = GravityAndOrbitsMode.getTargetRectangle(d * this.zoomLevel.get(), immutableVector2D);
        double d2 = double_.getMinX();
        double d3 = double_.getMinY();
        double d4 = double_.getMaxX() - d2;
        double d5 = double_.getMaxY() - d3;
        return ModelViewTransform.createRectangleInvertedYMapping(new Rectangle2D.Double(d2, d3, d4, d5), new Rectangle2D.Double(0.0, 0.0, PLAY_AREA_WIDTH, PLAY_AREA_HEIGHT));
    }

    public static Rectangle2D.Double getTargetRectangle(double d, ImmutableVector2D immutableVector2D) {
        double d2 = d * 1.5E-9;
        double d3 = PLAY_AREA_WIDTH / d2;
        double d4 = PLAY_AREA_HEIGHT / d2;
        return new Rectangle2D.Double(-d3 / 2.0 + immutableVector2D.getX(), -d4 / 2.0 + immutableVector2D.getY(), d3, d4);
    }

    public int getMaxPathLength() {
        double d = 1.5;
        return (int)Math.ceil(d * this.defaultOrbitalPeriod / this.dt);
    }

    public GravityAndOrbitsClock getClock() {
        return this.model.getClock();
    }

    public void addBody(Body body) {
        this.model.addBody(body);
        final SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                GravityAndOrbitsMode.this.deviatedFromDefaults.set(true);
            }
        };
        body.getMassProperty().addObserver(simpleObserver, false);
        VoidFunction0 voidFunction0 = new VoidFunction0(){

            public void apply() {
                simpleObserver.update();
            }
        };
        body.addUserModifiedPositionListener(voidFunction0);
        body.addUserModifiedVelocityListener(voidFunction0);
    }

    public GravityAndOrbitsModel getModel() {
        return this.model;
    }

    public void reset() {
        this.model.getClock().resetSimulationTime();
        this.model.resetAll();
        this.deviatedFromDefaults.reset();
        this.measuringTapeStartPoint.reset();
        this.measuringTapeEndPoint.reset();
        this.zoomLevel.reset();
    }

    public JComponent getCanvas() {
        return this.canvas;
    }

    public void init(GravityAndOrbitsModule gravityAndOrbitsModule) {
        this.canvas = new GravityAndOrbitsCanvas(this.model, gravityAndOrbitsModule, this, this.forceScale);
    }

    public JComponent newControl(final Property<GravityAndOrbitsMode> property) {
        return new JPanel(){
            {
                this.setForeground(GravityAndOrbitsControlPanel.FOREGROUND);
                this.add(new GAORadioButton<GravityAndOrbitsMode>(null, property, GravityAndOrbitsMode.this));
                this.add(new JLabel(new ImageIcon(GravityAndOrbitsMode.this.iconImage)){
                    {
                        this.addMouseListener(new MouseAdapter(){

                            public void mouseReleased(MouseEvent mouseEvent) {
                                property.set(GravityAndOrbitsMode.this);
                            }
                        });
                    }
                });
            }
        };
    }

    public Function1<Double, String> getTimeFormatter() {
        return this.timeFormatter;
    }

    public void resetMode() {
        this.model.resetBodies();
        this.deviatedFromDefaults.set(false);
        this.getClock().setSimulationTime(0.0);
    }

    public double getVelocityVectorScale() {
        return this.velocityVectorScale;
    }

    public void rewind() {
        this.rewinding.set(true);
        this.getClock().setSimulationTime(this.rewindClockTime);
        for (Body body : this.model.getBodies()) {
            body.rewind();
        }
        this.rewinding.set(false);
    }

    public double getGridSpacing() {
        return this.gridSpacing;
    }

    public Point2D.Double getGridCenter() {
        return this.gridCenter;
    }
}

