/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.module;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.gravityandorbits.module.ModeList;
import edu.colorado.phet.gravityandorbits.module.ModeListParameterList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CartoonModeList
extends ModeList {
    public CartoonModeList(Property<Boolean> property, Property<Boolean> property2, Property<Boolean> property3, Property<Boolean> property4, Property<Double> property5) {
        super(new ModeListParameterList(property, property2, property3, property4, property5), CartoonModeList.getSunEarth(), CartoonModeList.getSunEarthMoon(), CartoonModeList.getEarthMoon(), CartoonModeList.getEarthSpaceStation());
    }

    private static ModeList.SunEarthModeConfig getSunEarth() {
        return new ModeList.SunEarthModeConfig(){
            {
                this.sun.radius *= 50.0;
                this.earth.radius *= 800.0;
                this.earth.mass *= 10200.0;
                this.forceScale *= 5.617647058823529E-5;
                this.timeScale = 1.092814371257485;
                this.sun.fixed = true;
            }
        };
    }

    private static ModeList.SunEarthMoonModeConfig getSunEarthMoon() {
        return new ModeList.SunEarthMoonModeConfig(){
            {
                this.sun.radius *= 50.0;
                this.earth.radius *= 800.0;
                this.moon.radius *= 800.0;
                this.earth.mass *= 10200.0;
                this.moon.vx *= 21.0;
                this.moon.y = this.earth.radius * 1.7;
                this.forceScale *= 5.617647058823529E-5;
                this.timeScale = 1.092814371257485;
                this.sun.fixed = true;
            }
        };
    }

    private static ModeList.EarthMoonModeConfig getEarthMoon() {
        return new ModeList.EarthMoonModeConfig(){
            {
                this.earth.radius *= 15.0;
                this.moon.radius *= 15.0;
                this.forceScale *= 0.77;
            }
        };
    }

    private static ModeList.EarthSpaceStationModeConfig getEarthSpaceStation() {
        return new ModeList.EarthSpaceStationModeConfig(){
            {
                this.earth.radius *= 0.8;
                this.spaceStation.radius *= 8.0;
            }
        };
    }
}

