/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.gravityandorbits.model.BodyState;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelState {
    private ArrayList<BodyState> bodyStates;

    public ModelState(ArrayList<BodyState> arrayList) {
        this.bodyStates = arrayList;
    }

    public ModelState getNextState(double d, int n, Property<Boolean> property) {
        ModelState modelState = this;
        for (int i = 0; i < n; ++i) {
            modelState = modelState.getNextState(d / (double)n, property);
        }
        return modelState;
    }

    public ModelState getNextState(double d, Property<Boolean> property) {
        ArrayList<BodyState> arrayList = new ArrayList<BodyState>();
        for (BodyState bodyState : this.bodyStates) {
            ImmutableVector2D immutableVector2D = bodyState.position.getAddedInstance(bodyState.velocity.getScaledInstance(d)).getAddedInstance(bodyState.acceleration.getScaledInstance(d * d / 2.0));
            ImmutableVector2D immutableVector2D2 = bodyState.velocity.getAddedInstance(bodyState.acceleration.getScaledInstance(d / 2.0));
            ImmutableVector2D immutableVector2D3 = this.getForce(bodyState, immutableVector2D, property).getScaledInstance(-1.0 / bodyState.mass);
            ImmutableVector2D immutableVector2D4 = immutableVector2D2.getAddedInstance(immutableVector2D3.getScaledInstance(d / 2.0));
            arrayList.add(new BodyState(immutableVector2D, immutableVector2D4, immutableVector2D3, bodyState.mass, bodyState.exploded));
        }
        return new ModelState(arrayList);
    }

    private ImmutableVector2D getForce(BodyState bodyState, BodyState bodyState2, ImmutableVector2D immutableVector2D) {
        if (bodyState.position.equals(immutableVector2D)) {
            return new ImmutableVector2D();
        }
        if (bodyState.exploded) {
            return new ImmutableVector2D();
        }
        return this.getUnitVector(bodyState, immutableVector2D).getScaledInstance(6.67428E-11 * bodyState.mass * bodyState2.mass / bodyState.distanceSquared(immutableVector2D));
    }

    private ImmutableVector2D getUnitVector(BodyState bodyState, ImmutableVector2D immutableVector2D) {
        return immutableVector2D.getSubtractedInstance(bodyState.position).getNormalizedInstance();
    }

    private ImmutableVector2D getForce(BodyState bodyState, ImmutableVector2D immutableVector2D, Property<Boolean> property) {
        ImmutableVector2D immutableVector2D2 = new ImmutableVector2D();
        if (property.get().booleanValue()) {
            for (BodyState bodyState2 : this.bodyStates) {
                if (bodyState2 == bodyState) continue;
                immutableVector2D2 = immutableVector2D2.getAddedInstance(this.getForce(bodyState2, bodyState, immutableVector2D));
            }
        }
        return immutableVector2D2;
    }

    public BodyState getBodyState(int n) {
        return this.bodyStates.get(n);
    }
}

