/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.gravityandorbits.model.Body;
import edu.colorado.phet.gravityandorbits.model.BodyState;
import edu.colorado.phet.gravityandorbits.model.GravityAndOrbitsClock;
import edu.colorado.phet.gravityandorbits.model.ModelState;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GravityAndOrbitsModel {
    private final ArrayList<Body> bodies = new ArrayList();
    private final GravityAndOrbitsClock clock;
    private ArrayList<SimpleObserver> modelStepListeners = new ArrayList();
    public boolean teacherMode;
    private final VoidFunction1<Double> stepModel;

    public GravityAndOrbitsModel(GravityAndOrbitsClock gravityAndOrbitsClock, final Property<Boolean> property) {
        this.clock = gravityAndOrbitsClock;
        this.stepModel = new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                for (int i = 0; i < 5; ++i) {
                    this.performSubStep(d / 5.0);
                }
            }

            private void performSubStep(Double d) {
                ModelState modelState = new ModelState(new ArrayList<BodyState>(){
                    {
                        for (Body body : GravityAndOrbitsModel.this.bodies) {
                            this.add(body.toBodyState());
                        }
                    }
                }).getNextState(d, 80, property);
                for (int i = 0; i < GravityAndOrbitsModel.this.bodies.size(); ++i) {
                    ((Body)GravityAndOrbitsModel.this.bodies.get(i)).updateBodyStateFromModel(modelState.getBodyState(i));
                }
                for (Body body : GravityAndOrbitsModel.this.bodies) {
                    for (Body body2 : GravityAndOrbitsModel.this.bodies) {
                        if (body2 == body || !body2.collidesWidth(body)) continue;
                        this.getSmaller(body2, body).setCollided(true);
                    }
                }
                for (int i = 0; i < GravityAndOrbitsModel.this.bodies.size(); ++i) {
                    ((Body)GravityAndOrbitsModel.this.bodies.get(i)).allBodiesUpdated();
                }
            }

            private Body getSmaller(Body body, Body body2) {
                if (body.getMass() < body2.getMass()) {
                    return body;
                }
                return body2;
            }
        };
        gravityAndOrbitsClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                if (GravityAndOrbitsModel.this.teacherMode) {
                    return;
                }
                double d = clockEvent.getSimulationTimeChange();
                GravityAndOrbitsModel.this.stepModel.apply(d);
                for (SimpleObserver simpleObserver : GravityAndOrbitsModel.this.modelStepListeners) {
                    simpleObserver.update();
                }
            }
        });
        property.addObserver(new SimpleObserver(){

            public void update() {
                GravityAndOrbitsModel.this.updateForceVectors();
            }
        });
    }

    public GravityAndOrbitsClock getClock() {
        return this.clock;
    }

    public void resetAll() {
        this.resetBodies();
        this.getClock().resetSimulationTime();
        this.updateForceVectors();
    }

    public void addBody(Body body) {
        this.bodies.add(body);
        body.addUserModifiedPositionListener(new VoidFunction0(){

            public void apply() {
                if (GravityAndOrbitsModel.this.getClock().isPaused()) {
                    GravityAndOrbitsModel.this.updateForceVectors();
                }
            }
        });
        body.getMassProperty().addObserver(new SimpleObserver(){

            public void update() {
                if (GravityAndOrbitsModel.this.getClock().isPaused()) {
                    GravityAndOrbitsModel.this.updateForceVectors();
                }
            }
        });
        this.updateForceVectors();
    }

    private void updateForceVectors() {
        this.stepModel.apply(0.0);
    }

    public ArrayList<Body> getBodies() {
        return new ArrayList<Body>(this.bodies);
    }

    public void resetBodies() {
        for (Body body : this.bodies) {
            body.resetAll();
        }
        this.updateForceVectors();
    }

    public void returnBodies() {
        for (Body body : this.bodies) {
            body.returnBody(this);
        }
        this.updateForceVectors();
    }

    public Body getBody(String string) {
        for (Body body : this.bodies) {
            if (!body.getName().equalsIgnoreCase(string)) continue;
            return body;
        }
        return null;
    }
}

