/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function2;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.gravityandorbits.model.BodyState;
import edu.colorado.phet.gravityandorbits.model.GravityAndOrbitsModel;
import edu.colorado.phet.gravityandorbits.model.RewindableProperty;
import edu.colorado.phet.gravityandorbits.view.BodyRenderer;
import edu.colorado.phet.gravityandorbits.view.IBodyColors;
import edu.colorado.phet.gravityandorbits.view.MultiwayOr;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Body
implements IBodyColors {
    private final RewindableProperty<ImmutableVector2D> positionProperty;
    private final RewindableProperty<ImmutableVector2D> velocityProperty;
    private final Property<ImmutableVector2D> accelerationProperty;
    private final Property<ImmutableVector2D> forceProperty;
    private final RewindableProperty<Double> massProperty;
    private final Property<Double> diameterProperty;
    private final String name;
    private final Color color;
    private final Color highlight;
    private final double density;
    private boolean userControlled;
    private final ArrayList<PathListener> pathListeners = new ArrayList();
    private final ArrayList<ImmutableVector2D> path = new ArrayList();
    private final int maxPathLength;
    private final boolean massSettable;
    private final Function2<Body, Double, BodyRenderer> renderer;
    private final double labelAngle;
    private final boolean massReadoutBelow;
    private final RewindableProperty<Boolean> collidedProperty;
    private final Property<Integer> clockTicksSinceExplosion = new Property<Integer>(0);
    private double tickValue;
    private String tickLabel;
    private ArrayList<VoidFunction0> userModifiedPositionListeners = new ArrayList();
    private Property<Shape> bounds = new Property<Rectangle2D.Double>(new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0));
    public final boolean fixed;
    private ArrayList<VoidFunction0> userModifiedVelocityListeners = new ArrayList();

    public Body(String string, double d, double d2, double d3, double d4, double d5, double d6, Color color, Color color2, Function2<Body, Double, BodyRenderer> function2, double d7, boolean bl, int n, boolean bl2, double d8, String string2, Property<Boolean> property, Property<Boolean> property2, Property<Boolean> property3, boolean bl3) {
        this.massSettable = bl;
        this.maxPathLength = n;
        this.massReadoutBelow = bl2;
        this.tickValue = d8;
        this.tickLabel = string2;
        this.fixed = bl3;
        assert (function2 != null);
        this.name = string;
        this.color = color;
        this.highlight = color2;
        this.renderer = function2;
        this.labelAngle = d7;
        this.positionProperty = new RewindableProperty<ImmutableVector2D>(property, property2, property3, new ImmutableVector2D(d, d2));
        this.velocityProperty = new RewindableProperty<ImmutableVector2D>(property, property2, property3, new ImmutableVector2D(d4, d5));
        this.accelerationProperty = new Property<ImmutableVector2D>(new ImmutableVector2D(0.0, 0.0));
        this.forceProperty = new Property<ImmutableVector2D>(new ImmutableVector2D(0.0, 0.0));
        this.massProperty = new RewindableProperty<Double>(property, property2, property3, d6);
        this.diameterProperty = new Property<Double>(d3);
        this.collidedProperty = new RewindableProperty<Boolean>(property, property2, property3, false);
        this.density = d6 / this.getVolume();
        this.collidedProperty.addObserver(new SimpleObserver(){

            public void update() {
                if (((Boolean)Body.this.collidedProperty.get()).booleanValue()) {
                    Body.this.clockTicksSinceExplosion.set(0);
                }
            }
        });
        VoidFunction0 voidFunction0 = new VoidFunction0(){

            public void apply() {
                Body.this.positionProperty.storeRewindValueNoNotify();
                Body.this.velocityProperty.storeRewindValueNoNotify();
                Body.this.massProperty.storeRewindValueNoNotify();
                Body.this.collidedProperty.storeRewindValueNoNotify();
            }
        };
        this.positionProperty.addRewindValueChangeListener(voidFunction0);
        this.velocityProperty.addRewindValueChangeListener(voidFunction0);
        this.massProperty.addRewindValueChangeListener(voidFunction0);
        this.collidedProperty.addRewindValueChangeListener(voidFunction0);
    }

    public Property<Integer> getClockTicksSinceExplosion() {
        return this.clockTicksSinceExplosion;
    }

    private double getVolume() {
        return 4.1887902047863905 * Math.pow(this.getRadius(), 3.0);
    }

    public double getRadius() {
        return this.getDiameter() / 2.0;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Color getHighlight() {
        return this.highlight;
    }

    public RewindableProperty<ImmutableVector2D> getPositionProperty() {
        return this.positionProperty;
    }

    public ImmutableVector2D getPosition() {
        return (ImmutableVector2D)this.positionProperty.get();
    }

    public Property<Double> getDiameterProperty() {
        return this.diameterProperty;
    }

    public double getDiameter() {
        return this.diameterProperty.get();
    }

    public void translate(Point2D point2D) {
        this.translate(point2D.getX(), point2D.getY());
        if (!((Boolean)this.collidedProperty.get()).booleanValue() && !this.userControlled) {
            this.addPathPoint();
        }
    }

    public void translate(double d, double d2) {
        this.positionProperty.set(new ImmutableVector2D(this.getX() + d, this.getY() + d2));
    }

    public double getY() {
        return ((ImmutableVector2D)this.positionProperty.get()).getY();
    }

    public double getX() {
        return ((ImmutableVector2D)this.positionProperty.get()).getX();
    }

    public String getName() {
        return this.name;
    }

    public void setDiameter(double d) {
        this.diameterProperty.set(d);
    }

    public BodyState toBodyState() {
        return new BodyState(this.getPosition(), this.getVelocity(), this.getAcceleration(), this.getMass(), (Boolean)this.collidedProperty.get());
    }

    public double getMass() {
        return (Double)this.massProperty.get();
    }

    public ImmutableVector2D getAcceleration() {
        return this.accelerationProperty.get();
    }

    public ImmutableVector2D getVelocity() {
        return (ImmutableVector2D)this.velocityProperty.get();
    }

    public void updateBodyStateFromModel(BodyState bodyState) {
        if (((Boolean)this.collidedProperty.get()).booleanValue()) {
            this.clockTicksSinceExplosion.set(this.clockTicksSinceExplosion.get() + 1);
        } else {
            if (!this.isUserControlled()) {
                this.positionProperty.set(bodyState.position);
                this.velocityProperty.set(bodyState.velocity);
            }
            this.accelerationProperty.set(bodyState.acceleration);
            this.forceProperty.set(bodyState.acceleration.getScaledInstance(bodyState.mass));
        }
    }

    public void allBodiesUpdated() {
        if (!this.isUserControlled()) {
            this.addPathPoint();
        }
    }

    private void addPathPoint() {
        while (this.path.size() + 1 > this.maxPathLength * 5) {
            this.path.remove(0);
            for (PathListener object : this.pathListeners) {
                object.pointRemoved();
            }
        }
        ImmutableVector2D immutableVector2D = this.getPosition();
        this.path.add(immutableVector2D);
        for (PathListener pathListener : this.pathListeners) {
            pathListener.pointAdded(immutableVector2D);
        }
    }

    public void clearPath() {
        this.path.clear();
        for (PathListener pathListener : this.pathListeners) {
            pathListener.cleared();
        }
    }

    public Property<ImmutableVector2D> getForceProperty() {
        return this.forceProperty;
    }

    public void setMass(double d) {
        this.massProperty.set(d);
        double d2 = Math.pow(3.0 * d / 4.0 / Math.PI / this.density, 0.3333333333333333);
        this.diameterProperty.set(d2 * 2.0);
    }

    public void resetAll() {
        this.positionProperty.reset();
        this.velocityProperty.reset();
        this.accelerationProperty.reset();
        this.forceProperty.reset();
        this.massProperty.reset();
        this.diameterProperty.reset();
        this.collidedProperty.reset();
        this.clockTicksSinceExplosion.reset();
        this.clearPath();
    }

    public RewindableProperty<ImmutableVector2D> getVelocityProperty() {
        return this.velocityProperty;
    }

    public RewindableProperty<Double> getMassProperty() {
        return this.massProperty;
    }

    public boolean isUserControlled() {
        return this.userControlled;
    }

    public void setUserControlled(boolean bl) {
        this.userControlled = bl;
    }

    public void addPathListener(PathListener pathListener) {
        this.pathListeners.add(pathListener);
    }

    public void setVelocity(ImmutableVector2D immutableVector2D) {
        this.velocityProperty.set(immutableVector2D);
    }

    public void setPosition(double d, double d2) {
        this.positionProperty.set(new ImmutableVector2D(d, d2));
    }

    public void setAcceleration(ImmutableVector2D immutableVector2D) {
        this.accelerationProperty.set(immutableVector2D);
    }

    public void setForce(ImmutableVector2D immutableVector2D) {
        this.forceProperty.set(immutableVector2D);
    }

    public boolean isMassSettable() {
        return this.massSettable;
    }

    public BodyRenderer createRenderer(double d) {
        return this.renderer.apply(this, d);
    }

    public double getLabelAngle() {
        return this.labelAngle;
    }

    public int getMaxPathLength() {
        return this.maxPathLength * 5;
    }

    public boolean isMassReadoutBelow() {
        return this.massReadoutBelow;
    }

    public Property<Boolean> getCollidedProperty() {
        return this.collidedProperty;
    }

    public boolean collidesWidth(Body body) {
        double d;
        double d2 = this.getPosition().getSubtractedInstance(body.getPosition()).getMagnitude();
        return d2 < (d = this.getDiameter() / 2.0 + body.getDiameter() / 2.0);
    }

    public void setCollided(boolean bl) {
        this.collidedProperty.set(bl);
    }

    public double getTickValue() {
        return this.tickValue;
    }

    public String getTickLabel() {
        return this.tickLabel;
    }

    public void addUserModifiedPositionListener(VoidFunction0 voidFunction0) {
        this.userModifiedPositionListeners.add(voidFunction0);
    }

    public void notifyUserModifiedPosition() {
        for (VoidFunction0 voidFunction0 : this.userModifiedPositionListeners) {
            voidFunction0.apply();
        }
    }

    public void addUserModifiedVelocityListener(VoidFunction0 voidFunction0) {
        this.userModifiedVelocityListeners.add(voidFunction0);
    }

    public void notifyUserModifiedVelocity() {
        for (VoidFunction0 voidFunction0 : this.userModifiedVelocityListeners) {
            voidFunction0.apply();
        }
    }

    public void rewind() {
        this.positionProperty.rewind();
        this.velocityProperty.rewind();
        this.massProperty.rewind();
        this.collidedProperty.rewind();
        this.clearPath();
    }

    public Property<Boolean> anyPropertyDifferent() {
        return new MultiwayOr(Arrays.asList(this.positionProperty.different(), this.velocityProperty.different(), this.massProperty.different(), this.collidedProperty.different()));
    }

    public void returnBody(GravityAndOrbitsModel gravityAndOrbitsModel) {
        if (((Boolean)this.collidedProperty.get()).booleanValue() || !this.bounds.get().contains(this.getPosition().toPoint2D())) {
            this.setCollided(false);
            this.clearPath();
            this.doReturnBody(gravityAndOrbitsModel);
        }
    }

    protected void doReturnBody(GravityAndOrbitsModel gravityAndOrbitsModel) {
        this.positionProperty.reset();
        this.velocityProperty.reset();
    }

    public String toString() {
        return "name = " + this.getName() + ", mass = " + this.getMass();
    }

    public Property<Shape> getBounds() {
        return this.bounds;
    }

    public static interface PathListener {
        public void pointAdded(ImmutableVector2D var1);

        public void pointRemoved();

        public void cleared();
    }
}

