/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.controlpanel;

import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.colorado.phet.common.phetcommon.view.PhetLineBorder;
import edu.colorado.phet.common.phetcommon.view.PhetTitledBorder;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.gravityandorbits.GAOStrings;
import edu.colorado.phet.gravityandorbits.controlpanel.BodyMassControl;
import edu.colorado.phet.gravityandorbits.controlpanel.GAOCheckBox;
import edu.colorado.phet.gravityandorbits.controlpanel.GAORadioButton;
import edu.colorado.phet.gravityandorbits.model.Body;
import edu.colorado.phet.gravityandorbits.model.GravityAndOrbitsModel;
import edu.colorado.phet.gravityandorbits.module.GravityAndOrbitsMode;
import edu.colorado.phet.gravityandorbits.module.GravityAndOrbitsModule;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.geom.Point2D;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GravityAndOrbitsControlPanel
extends VerticalLayoutPanel {
    public static final Color BACKGROUND = new Color(3, 0, 133);
    public static final Color FOREGROUND = Color.white;
    public static final Font CONTROL_FONT = new PhetFont(16, true);

    public GravityAndOrbitsControlPanel(final GravityAndOrbitsModule gravityAndOrbitsModule, GravityAndOrbitsModel gravityAndOrbitsModel) {
        this.setFillNone();
        this.setAnchor(17);
        for (GravityAndOrbitsMode object : gravityAndOrbitsModule.getModes()) {
            this.add(object.newControl(gravityAndOrbitsModule.modeProperty));
        }
        this.setFillHorizontal();
        this.add(new VerticalLayoutPanel(){
            {
                this.setOpaque(false);
                this.setAnchor(17);
                this.setFill(0);
                this.setBorder(new PhetTitledBorder(new PhetLineBorder(Color.white), GAOStrings.PHYSICS){
                    {
                        this.setTitleColor(Color.white);
                        this.setTitleFont(CONTROL_FONT);
                    }
                });
                this.add(new HorizontalLayoutPanel(){
                    {
                        this.add(new JLabel(MessageFormat.format(GAOStrings.PATTERN_LABEL, GAOStrings.GRAVITY)){
                            {
                                GravityAndOrbitsControlPanel.setFontsAndColors(this);
                            }
                        });
                        this.add(Box.createRigidArea(new Dimension(20, 1)));
                        this.add(new GAORadioButton<Boolean>(GAOStrings.ON, gravityAndOrbitsModule.gravityEnabledProperty, Boolean.valueOf(true)));
                        this.add(new GAORadioButton<Boolean>(GAOStrings.OFF, gravityAndOrbitsModule.gravityEnabledProperty, Boolean.valueOf(false)));
                    }
                });
            }
        });
        this.add(new VerticalLayoutPanel(){
            {
                this.setOpaque(false);
                this.setBorder(new PhetTitledBorder(new PhetLineBorder(Color.white), GAOStrings.SHOW){
                    {
                        this.setTitleColor(Color.white);
                        this.setTitleFont(CONTROL_FONT);
                    }
                });
                this.setFillNone();
                this.setAnchor(17);
                this.add(new JPanel(new GridLayout(2, 2)){
                    {
                        this.setOpaque(false);
                        this.add(new GAOCheckBox(GAOStrings.GRAVITY_FORCE, gravityAndOrbitsModule.showGravityForceProperty));
                        this.add(GravityAndOrbitsControlPanel.this.newArrow(PhetColorScheme.GRAVITATIONAL_FORCE));
                        this.add(new GAOCheckBox(GAOStrings.VELOCITY, gravityAndOrbitsModule.showVelocityProperty));
                        this.add(GravityAndOrbitsControlPanel.this.newArrow(PhetColorScheme.VELOCITY));
                        this.setMaximumSize(this.getPreferredSize());
                    }
                });
                if (gravityAndOrbitsModule.showMassCheckBox) {
                    this.add(new GAOCheckBox(GAOStrings.MASS, gravityAndOrbitsModule.showMassProperty));
                }
                this.add(new GAOCheckBox(GAOStrings.PATH, gravityAndOrbitsModule.showPathProperty));
                this.add(new GAOCheckBox(GAOStrings.GRID, gravityAndOrbitsModule.showGridProperty));
                if (gravityAndOrbitsModule.showMeasuringTape) {
                    this.add(new GAOCheckBox(GAOStrings.MEASURING_TAPE, gravityAndOrbitsModule.measuringTapeVisibleProperty));
                }
            }
        });
        for (Body body : gravityAndOrbitsModel.getBodies()) {
            if (!body.isMassSettable()) continue;
            this.add(new BodyMassControl(body, body.getMassProperty().getInitialValue() / 2.0, body.getMassProperty().getInitialValue() * 2.0, body.getTickValue(), body.getTickLabel(), gravityAndOrbitsModule.whiteBackgroundProperty));
        }
    }

    private JLabel newArrow(final Color color) {
        return new JLabel(new ImageIcon(new ArrowNode(new Point2D.Double(), new Point2D.Double(65.0, 0.0), 15.0, 15.0, 5.0, 2.0, true){
            {
                super(point2D, point2D2, d, d2, d3, d4, bl);
                this.setPaint(color);
                this.setStrokePaint(Color.darkGray);
            }
        }.toImage()));
    }

    private static void setFontsAndColors(JComponent jComponent) {
        jComponent.setFont(CONTROL_FONT);
        jComponent.setForeground(FOREGROUND);
    }
}

