/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.controlpanel;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.gravityandorbits.controlpanel.GravityAndOrbitsControlPanel;
import edu.colorado.phet.gravityandorbits.model.Body;
import edu.colorado.phet.gravityandorbits.view.BodyNode;
import edu.colorado.phet.gravityandorbits.view.GravityAndOrbitsCanvas;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BodyMassControl
extends VerticalLayoutPanel {
    private static double SNAP_TOLERANCE = 0.08;
    private boolean updatingSlider = false;

    public BodyMassControl(final Body body, double d, double d2, final double d3, final String string, final Property<Boolean> property) {
        final Function.LinearFunction linearFunction = new Function.LinearFunction(d, d2, 0.0, 100000.0);
        this.setInsets(new Insets(5, 5, 5, 5));
        this.add(new JPanel(){
            {
                this.add(new JLabel(body.getName()){
                    {
                        this.setFont(GravityAndOrbitsControlPanel.CONTROL_FONT);
                        this.setForeground(GravityAndOrbitsControlPanel.FOREGROUND);
                    }
                });
                BodyNode bodyNode = new BodyNode(body, new Property<ModelViewTransform>(ModelViewTransform.createSinglePointScaleInvertedYMapping(new Point2D.Double(0.0, 0.0), new Point2D.Double(GravityAndOrbitsCanvas.STAGE_SIZE.width * 0.3, GravityAndOrbitsCanvas.STAGE_SIZE.height * 0.5), 1.0E-9)), new Property<ImmutableVector2D>(new ImmutableVector2D(0.0, 0.0)), null, -0.7853981633974483, property);
                Image image = bodyNode.renderImage(22);
                this.add(new JLabel(new ImageIcon(image), 2));
            }
        });
        this.setForeground(GravityAndOrbitsControlPanel.FOREGROUND);
        this.add(new JSlider(0, 100000){
            {
                super(n, n2);
                this.setMajorTickSpacing((int)(linearFunction.evaluate(d3) - 0.0));
                this.setPaintLabels(true);
                this.setPaintTicks(true);
                this.setLabelTable(new Hashtable<Object, Object>(){
                    {
                        class 1SmallLabel
                        extends JLabel {
                            1SmallLabel(String string) {
                                super(string);
                                this.setForeground(GravityAndOrbitsControlPanel.FOREGROUND);
                                this.setFont(new PhetFont(14));
                            }
                        }
                        this.put((int)linearFunction.evaluate(d3), new 1SmallLabel(string));
                    }
                });
                this.setForeground(GravityAndOrbitsControlPanel.FOREGROUND);
                body.getMassProperty().addObserver(new SimpleObserver(){

                    public void update() {
                        BodyMassControl.this.updatingSlider = true;
                        this.setValue((int)linearFunction.evaluate(body.getMass()));
                        BodyMassControl.this.updatingSlider = false;
                    }
                });
                this.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        if (!BodyMassControl.this.updatingSlider) {
                            double d = linearFunction.createInverse().evaluate(this.getValue());
                            if (Math.abs(d - d3) / d3 < SNAP_TOLERANCE) {
                                body.setMass(d3);
                            } else {
                                body.setMass(linearFunction.createInverse().evaluate(this.getValue()));
                            }
                        }
                    }
                });
                this.addMouseListener(new MouseAdapter(){

                    public void mouseReleased(MouseEvent mouseEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                double d = linearFunction.createInverse().evaluate(this.getValue());
                                if (Math.abs(d - d3) / d3 < SNAP_TOLERANCE) {
                                    body.setMass(d3);
                                    body.getMassProperty().notifyIfChanged();
                                }
                            }
                        });
                    }
                });
            }
        });
    }
}

