/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits;

import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.resources.PhetResources;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.menu.OptionsMenu;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.gravityandorbits.GAOStrings;
import edu.colorado.phet.gravityandorbits.module.CartoonModeList;
import edu.colorado.phet.gravityandorbits.module.GravityAndOrbitsMode;
import edu.colorado.phet.gravityandorbits.module.GravityAndOrbitsModule;
import edu.colorado.phet.gravityandorbits.module.ModeListParameterList;
import edu.colorado.phet.gravityandorbits.module.RealModeList;
import java.util.ArrayList;

public class GravityAndOrbitsApplication
extends PiccoloPhetApplication {
    public static final String PROJECT_NAME = "gravity-and-orbits";
    public static final PhetResources RESOURCES = new PhetResources("gravity-and-orbits");
    private final GravityAndOrbitsModule intro;
    private final GravityAndOrbitsModule toScale;
    private final Property<Boolean> whiteBackgroundProperty = new Property<Boolean>(false);

    public GravityAndOrbitsApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.intro = new IntroModule(this.getPhetFrame(), this.whiteBackgroundProperty);
        this.addModule(this.intro);
        this.toScale = new CartoonModule(this.getPhetFrame(), this.whiteBackgroundProperty);
        this.addModule(this.toScale);
        this.getPhetFrame().addMenu(new OptionsMenu(){
            {
                this.addWhiteBackgroundCheckBoxMenuItem(GravityAndOrbitsApplication.this.whiteBackgroundProperty);
            }
        });
    }

    public GravityAndOrbitsModule getIntro() {
        return this.intro;
    }

    public GravityAndOrbitsModule getToScale() {
        return this.toScale;
    }

    public static void main(String[] stringArray) throws ClassNotFoundException {
        new PhetApplicationLauncher().launchSim(stringArray, PROJECT_NAME, GravityAndOrbitsApplication.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CartoonModule
    extends GravityAndOrbitsModule {
        public CartoonModule(PhetFrame phetFrame, Property<Boolean> property) {
            super(phetFrame, property, GAOStrings.TO_SCALE, true, new Function1<ModeListParameterList, ArrayList<GravityAndOrbitsMode>>(){

                @Override
                public ArrayList<GravityAndOrbitsMode> apply(ModeListParameterList modeListParameterList) {
                    return new RealModeList(modeListParameterList.playButtonPressed, modeListParameterList.gravityEnabled, modeListParameterList.stepping, modeListParameterList.rewinding, modeListParameterList.timeSpeedScale);
                }
            }, 3, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntroModule
    extends GravityAndOrbitsModule {
        public IntroModule(PhetFrame phetFrame, Property<Boolean> property) {
            super(phetFrame, property, GAOStrings.CARTOON, false, new Function1<ModeListParameterList, ArrayList<GravityAndOrbitsMode>>(){

                @Override
                public ArrayList<GravityAndOrbitsMode> apply(ModeListParameterList modeListParameterList) {
                    return new CartoonModeList(modeListParameterList.playButtonPressed, modeListParameterList.gravityEnabled, modeListParameterList.stepping, modeListParameterList.rewinding, modeListParameterList.timeSpeedScale);
                }
            }, 0, false);
        }
    }
}

