/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.mediabuttons;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.DefaultIconButton;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PlayPauseButton;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.RewindButton;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.StepButton;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatingClockControlNode
extends PNode {
    private final double DISABLED_IMAGE_RESCALE_OP_SCALE = 1.0;
    private final PlayPauseButton playPauseButton;
    private final StepButton stepButton;

    public FloatingClockControlNode(SettableProperty<Boolean> settableProperty, final Function1<Double, String> function1, final IClock iClock, String string, ObservableProperty<Color> observableProperty) {
        this(settableProperty, function1 == null ? null : new Property<String>(function1.apply(iClock.getSimulationTime())){
            {
                super(string);
                iClock.addClockListener(new ClockAdapter(){

                    public void simulationTimeChanged(ClockEvent clockEvent) {
                        this.set(function1.apply(iClock.getSimulationTime()));
                    }
                });
            }
        }, new VoidFunction0(){

            public void apply() {
                iClock.stepClockWhilePaused();
            }
        }, new VoidFunction0(){

            public void apply() {
                iClock.setSimulationTime(0.0);
            }
        }, new Property<Double>(Double.valueOf(iClock.getSimulationTime())){
            {
                super(d);
                iClock.addClockListener(new ClockAdapter(){

                    public void simulationTimeChanged(ClockEvent clockEvent) {
                        this.set(iClock.getSimulationTime());
                    }
                });
            }
        }, string, observableProperty);
    }

    public FloatingClockControlNode(final SettableProperty<Boolean> settableProperty, final Property<String> property, final VoidFunction0 voidFunction0, final VoidFunction0 voidFunction02, final Property<Double> property2, String string, final ObservableProperty<Color> observableProperty) {
        this.playPauseButton = new PlayPauseButton(80){
            {
                super(n);
                this.setPlaying((Boolean)settableProperty.get());
                PlayPauseButton.Listener listener = new PlayPauseButton.Listener(){

                    public void playbackStateChanged() {
                        settableProperty.set(this.isPlaying());
                    }
                };
                this.addListener(listener);
                listener.playbackStateChanged();
                settableProperty.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setPlaying((Boolean)settableProperty.get());
                    }
                });
            }
        };
        this.stepButton = new StepButton(60){
            {
                super(n);
                this.setOffset(FloatingClockControlNode.this.playPauseButton.getFullBounds().getMaxX() + 5.0, FloatingClockControlNode.this.playPauseButton.getFullBounds().getCenterY() - this.getFullBounds().getHeight() / 2.0);
                final PlayPauseButton.Listener listener = new PlayPauseButton.Listener(){

                    public void playbackStateChanged() {
                        this.setEnabled(!FloatingClockControlNode.this.playPauseButton.isPlaying());
                    }
                };
                settableProperty.addObserver(new SimpleObserver(){

                    public void update() {
                        listener.playbackStateChanged();
                    }
                });
                FloatingClockControlNode.this.playPauseButton.addListener(listener);
                listener.playbackStateChanged();
                this.addListener(new DefaultIconButton.Listener(){

                    public void buttonPressed() {
                        if (this.isEnabled()) {
                            voidFunction0.apply();
                        }
                    }
                });
            }

            protected double getDisabledImageRescaleOpScale() {
                return 1.0;
            }
        };
        this.addChild(this.playPauseButton);
        this.addChild(this.stepButton);
        if (property != null) {
            final PText pText = new PText(){
                {
                    this.setFont(new PhetFont(24, true));
                    observableProperty.addObserver(new SimpleObserver(){

                        public void update() {
                            this.setTextPaint((Paint)observableProperty.get());
                        }
                    });
                    property.addObserver(new SimpleObserver(){

                        public void update() {
                            this.setText((String)property.get());
                            this.setOffset(FloatingClockControlNode.this.stepButton.getFullBounds().getMaxX() + 5.0, FloatingClockControlNode.this.stepButton.getFullBounds().getCenterY() - this.getFullBounds().getHeight() / 2.0);
                        }
                    });
                }
            };
            this.addChild(pText);
            if (string != null && string.length() > 0) {
                this.addChild(new HTMLImageButtonNode(string){
                    {
                        super(string);
                        this.setOffset(pText.getFullBounds().getCenterX() - this.getFullBounds().getWidth() / 2.0, pText.getFullBounds().getMaxY());
                        this.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                voidFunction02.apply();
                            }
                        });
                        property2.addObserver(new SimpleObserver(){

                            public void update() {
                                this.setEnabled((Double)property2.get() > 0.0);
                            }
                        });
                    }
                });
            }
        }
    }

    public PlayPauseButton getPlayPauseButton() {
        return this.playPauseButton;
    }

    public class FloatingRewindButton
    extends RewindButton {
        public FloatingRewindButton() {
            super(60);
            this.setOffset(FloatingClockControlNode.this.getPlayPauseButton().getFullBounds().getMinX() - this.getFullBounds().getWidth() - 5.0, FloatingClockControlNode.this.getPlayPauseButton().getFullBounds().getCenterY() - this.getFullBounds().getHeight() / 2.0);
        }

        protected double getDisabledImageRescaleOpScale() {
            return 1.0;
        }
    }
}

