/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view.tools;

import edu.colorado.phet.glaciers.model.AbstractTool;
import edu.colorado.phet.glaciers.model.BoreholeDrill;
import edu.colorado.phet.glaciers.model.GPSReceiver;
import edu.colorado.phet.glaciers.model.GlacialBudgetMeter;
import edu.colorado.phet.glaciers.model.GlaciersModel;
import edu.colorado.phet.glaciers.model.IceThicknessTool;
import edu.colorado.phet.glaciers.model.Thermometer;
import edu.colorado.phet.glaciers.model.TracerFlag;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.colorado.phet.glaciers.view.tools.AbstractToolNode;
import edu.colorado.phet.glaciers.view.tools.BoreholeDrillNode;
import edu.colorado.phet.glaciers.view.tools.GPSReceiverNode;
import edu.colorado.phet.glaciers.view.tools.GlacialBudgetMeterNode;
import edu.colorado.phet.glaciers.view.tools.IceThicknessToolNode;
import edu.colorado.phet.glaciers.view.tools.ThermometerNode;
import edu.colorado.phet.glaciers.view.tools.TracerFlagNode;
import edu.colorado.phet.glaciers.view.tools.TrashCanDelegate;

public class ToolNodeFactory {
    public static AbstractToolNode createNode(AbstractTool abstractTool, GlaciersModel glaciersModel, GlaciersModelViewTransform glaciersModelViewTransform, TrashCanDelegate trashCanDelegate, boolean bl) {
        AbstractToolNode abstractToolNode = null;
        if (abstractTool instanceof Thermometer) {
            abstractToolNode = new ThermometerNode((Thermometer)abstractTool, glaciersModel.getGlacier(), glaciersModelViewTransform, trashCanDelegate);
        } else if (abstractTool instanceof GlacialBudgetMeter) {
            abstractToolNode = new GlacialBudgetMeterNode((GlacialBudgetMeter)abstractTool, glaciersModel.getGlacier(), glaciersModelViewTransform, trashCanDelegate, bl);
        } else if (abstractTool instanceof TracerFlag) {
            abstractToolNode = new TracerFlagNode((TracerFlag)abstractTool, glaciersModelViewTransform, trashCanDelegate);
        } else if (abstractTool instanceof IceThicknessTool) {
            abstractToolNode = new IceThicknessToolNode((IceThicknessTool)abstractTool, glaciersModelViewTransform, trashCanDelegate, bl);
        } else if (abstractTool instanceof BoreholeDrill) {
            abstractToolNode = new BoreholeDrillNode((BoreholeDrill)abstractTool, glaciersModelViewTransform, trashCanDelegate);
        } else if (abstractTool instanceof GPSReceiver) {
            abstractToolNode = new GPSReceiverNode((GPSReceiver)abstractTool, glaciersModelViewTransform, trashCanDelegate, bl);
        } else {
            throw new UnsupportedOperationException("no node for tool type " + abstractTool.getClass());
        }
        return abstractToolNode;
    }
}

