/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view.tools;

import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.piccolophet.nodes.LiquidExpansionThermometerNode;
import edu.colorado.phet.glaciers.GlaciersStrings;
import edu.colorado.phet.glaciers.model.Glacier;
import edu.colorado.phet.glaciers.model.Movable;
import edu.colorado.phet.glaciers.model.Thermometer;
import edu.colorado.phet.glaciers.util.UnitsConverter;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.colorado.phet.glaciers.view.tools.AbstractToolNode;
import edu.colorado.phet.glaciers.view.tools.AbstractToolOriginNode;
import edu.colorado.phet.glaciers.view.tools.TrashCanDelegate;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class ThermometerNode
extends AbstractToolNode {
    private static final PDimension THERMOMETER_SIZE = new PDimension(15.0, 60.0);
    private static final NumberFormat TEMPERATURE_FORMAT = new DefaultDecimalFormat("0.0");
    private final Thermometer _thermometer;
    private final Glacier _glacier;
    private final Thermometer.ThermometerListener _thermometerListener;
    private final Movable.MovableListener _movableListener;
    private final Glacier.GlacierListener _glacierListener;
    private final GlassNode _glassNode;
    private final ValueNode _valueNode;

    public ThermometerNode(Thermometer thermometer, Glacier glacier, GlaciersModelViewTransform glaciersModelViewTransform, TrashCanDelegate trashCanDelegate) {
        super(thermometer, glaciersModelViewTransform, trashCanDelegate);
        this._thermometer = thermometer;
        this._glacier = glacier;
        this._thermometerListener = new Thermometer.ThermometerListener(){

            public void temperatureChanged() {
                ThermometerNode.this.updateTemperature();
            }
        };
        this._thermometer.addThermometerListener(this._thermometerListener);
        this._movableListener = new Movable.MovableAdapter(){

            public void positionChanged() {
                ThermometerNode.this.updateTemperature();
            }
        };
        this._thermometer.addMovableListener(this._movableListener);
        this._glacierListener = new Glacier.GlacierAdapter(){

            public void iceThicknessChanged() {
                ThermometerNode.this.updateTemperature();
            }
        };
        this._glacier.addGlacierListener(this._glacierListener);
        AbstractToolOriginNode.LeftToolOriginNode leftToolOriginNode = new AbstractToolOriginNode.LeftToolOriginNode();
        this.addChild(leftToolOriginNode);
        this._glassNode = new GlassNode(THERMOMETER_SIZE);
        this.addChild(this._glassNode);
        this._valueNode = new ValueNode(ThermometerNode.getValueFont(), ThermometerNode.getValueBorder());
        this.addChild(this._valueNode);
        leftToolOriginNode.setOffset(0.0, 0.0);
        this._glassNode.setOffset(leftToolOriginNode.getFullBoundsReference().getMaxX() + 2.0, -this._glassNode.getFullBoundsReference().getHeight() + this._glassNode.getBulbDiameter() / 2.0);
        this._valueNode.setOffset(this._glassNode.getFullBoundsReference().getMaxX() + 2.0, -this._valueNode.getFullBoundsReference().getHeight());
        this._valueNode.setTemperatureUnknown();
    }

    public void cleanup() {
        this._thermometer.removeThermometerListener(this._thermometerListener);
        this._thermometer.removeMovableListener(this._movableListener);
        this._glacier.removeGlacierListener(this._glacierListener);
        super.cleanup();
    }

    private void updateTemperature() {
        double d = this._glacier.getSurfaceElevation(this._thermometer.getX());
        if (this._thermometer.getY() > d) {
            double d2 = this._thermometer.getTemperature();
            double d3 = 1.0 - (10.0 - d2) / 30.0;
            if (d3 < 0.0) {
                d3 = 0.0;
            } else if (d3 > 1.0) {
                d3 = 1.0;
            }
            this._glassNode.setLiquidHeight(d3);
            this._valueNode.setTemperature(d2);
        } else {
            this._glassNode.setLiquidHeight(0.0);
            this._valueNode.setTemperatureUnknown();
        }
    }

    public static Image createImage() {
        GlassNode glassNode = new GlassNode(THERMOMETER_SIZE);
        glassNode.setLiquidHeight(0.5);
        return glassNode.toImage();
    }

    private static class GlassNode
    extends LiquidExpansionThermometerNode {
        public GlassNode(PDimension pDimension) {
            super(pDimension);
            this.setInnerWallVisible(false);
        }
    }

    private static class ValueNode
    extends PComposite {
        private JLabel _celsiusLabel = new JLabel("0");
        private JLabel _fahrenheitLabel;
        private PSwing _pswing;

        public ValueNode(Font font, Border border) {
            this._celsiusLabel.setFont(font);
            this._fahrenheitLabel = new JLabel("0");
            this._fahrenheitLabel.setFont(font);
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.WHITE);
            jPanel.setBorder(border);
            EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
            easyGridBagLayout.setAnchor(13);
            jPanel.setLayout(easyGridBagLayout);
            easyGridBagLayout.addComponent(this._fahrenheitLabel, 0, 0);
            easyGridBagLayout.addComponent(this._celsiusLabel, 1, 0);
            this._pswing = new PSwing(jPanel);
            this.addChild(this._pswing);
        }

        public void setTemperature(double d) {
            String string = TEMPERATURE_FORMAT.format(d) + " " + GlaciersStrings.UNITS_CELSIUS;
            this._celsiusLabel.setText(string);
            double d2 = UnitsConverter.celsiusToFahrenheit(d);
            String string2 = TEMPERATURE_FORMAT.format(d2) + " " + GlaciersStrings.UNITS_FAHRENHEIT;
            this._fahrenheitLabel.setText(string2);
            this._pswing.updateBounds();
        }

        public void setTemperatureUnknown() {
            this._celsiusLabel.setText("? " + GlaciersStrings.UNITS_CELSIUS);
            this._fahrenheitLabel.setText("? " + GlaciersStrings.UNITS_FAHRENHEIT);
            this._pswing.updateBounds();
        }
    }
}

