/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view.tools;

import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.glaciers.GlaciersStrings;
import edu.colorado.phet.glaciers.model.AbstractTool;
import edu.colorado.phet.glaciers.model.IceThicknessTool;
import edu.colorado.phet.glaciers.model.Movable;
import edu.colorado.phet.glaciers.util.UnitsConverter;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.colorado.phet.glaciers.view.tools.AbstractToolNode;
import edu.colorado.phet.glaciers.view.tools.TrashCanDelegate;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class IceThicknessToolNode
extends AbstractToolNode {
    private static final NumberFormat ICE_THICKNESS_FORMAT = new DefaultDecimalFormat("0.0");
    private static final PDimension HANDLE_SIZE = new PDimension(5.0, 20.0);
    private static final PDimension CALIPERS_CLOSED_SIZE = new PDimension(25.0, 20.0);
    private final IceThicknessTool _iceThicknessTool;
    private final IceThicknessTool.IceThicknessToolListener _iceThicknessToolListener;
    private final Movable.MovableListener _movableListener;
    private final AbstractTool.ToolListener _toolListener;
    private final CalipersNode _calipersNode;
    private final ValueNode _valueNode;

    public IceThicknessToolNode(IceThicknessTool iceThicknessTool, GlaciersModelViewTransform glaciersModelViewTransform, TrashCanDelegate trashCanDelegate, boolean bl) {
        super(iceThicknessTool, glaciersModelViewTransform, trashCanDelegate);
        this._iceThicknessTool = iceThicknessTool;
        this._iceThicknessToolListener = new IceThicknessTool.IceThicknessToolListener(){

            public void thicknessChanged() {
                IceThicknessToolNode.this.update();
            }
        };
        this._iceThicknessTool.addIceThicknessToolListener(this._iceThicknessToolListener);
        this._movableListener = new Movable.MovableAdapter(){

            public void positionChanged() {
                IceThicknessToolNode.this.update();
            }
        };
        this._iceThicknessTool.addMovableListener(this._movableListener);
        this._toolListener = new AbstractTool.ToolAdapter(){

            public void draggingChanged() {
                IceThicknessToolNode.this.update();
            }
        };
        this._iceThicknessTool.addToolListener(this._toolListener);
        this.addInputEventListener(new PDragEventHandler(){

            protected void startDrag(PInputEvent pInputEvent) {
                IceThicknessToolNode.this.updateUnknown();
                super.startDrag(pInputEvent);
            }

            protected void drag(PInputEvent pInputEvent) {
            }
        });
        this._calipersNode = new CalipersNode(CALIPERS_CLOSED_SIZE);
        this.addChild(this._calipersNode);
        this._calipersNode.setOffset(0.0, 0.0);
        HandleNode handleNode = new HandleNode(HANDLE_SIZE);
        this.addChild(handleNode);
        handleNode.setOffset(-handleNode.getFullBoundsReference().getWidth(), this._calipersNode.getFullBoundsReference().getMaxY());
        this._valueNode = new ValueNode(IceThicknessToolNode.getValueFont(), IceThicknessToolNode.getValueBorder(), bl);
        this.addChild(this._valueNode);
        this._valueNode.setOffset(3.0, -this._valueNode.getFullBoundsReference().getHeight() + this._calipersNode.getJawsHeight());
        this.updateUnknown();
    }

    public void cleanup() {
        this._iceThicknessTool.removeIceThicknessToolListener(this._iceThicknessToolListener);
        this._iceThicknessTool.removeMovableListener(this._movableListener);
        this._iceThicknessTool.removeToolListener(this._toolListener);
        super.cleanup();
    }

    public void setEnglishUnits(boolean bl) {
        this._valueNode.setEnglishUnits(bl);
        this.update();
    }

    private void update() {
        if (!this._iceThicknessTool.isDragging()) {
            double d = this._iceThicknessTool.getThickness();
            if (d == 0.0) {
                this.updateUnknown();
            } else {
                this._valueNode.setThickness(d);
                double d2 = Math.abs(this.getModelViewTransform().modelToView(0.0, d).getY());
                this._calipersNode.open(d2);
            }
        }
    }

    private void updateUnknown() {
        this._valueNode.setThickness("?");
        this._calipersNode.open(20.0);
    }

    public static Image createImage() {
        PNode pNode = new PNode();
        CalipersNode calipersNode = new CalipersNode(CALIPERS_CLOSED_SIZE);
        calipersNode.open(20.0);
        pNode.addChild(calipersNode);
        HandleNode handleNode = new HandleNode(HANDLE_SIZE);
        pNode.addChild(handleNode);
        calipersNode.setOffset(0.0, 0.0);
        handleNode.setOffset(-handleNode.getFullBoundsReference().getWidth(), calipersNode.getFullBoundsReference().getMaxY());
        return pNode.toImage();
    }

    private static class CalipersNode
    extends PComposite {
        private static final Stroke STROKE = new BasicStroke(1.0f);
        private static final Color STROKE_COLOR = Color.BLACK;
        private static final Color FILL_COLOR = new Color(140, 136, 120);
        private PDimension _closedSize;
        private GeneralPath _path;
        private PPath _pathNode;

        public CalipersNode(PDimension pDimension) {
            this._closedSize = new PDimension(pDimension);
            this._path = new GeneralPath();
            this._pathNode = new PPath();
            this._pathNode.setStroke(STROKE);
            this._pathNode.setStrokePaint(STROKE_COLOR);
            this._pathNode.setPaint(FILL_COLOR);
            this.addChild(this._pathNode);
            this.open(20.0);
        }

        public double getJawsHeight() {
            return this._closedSize.getHeight() / 2.0;
        }

        public void open(double d) {
            double d2 = this._closedSize.getWidth();
            double d3 = this._closedSize.getHeight() + d;
            double d4 = this.getJawsHeight();
            double d5 = d4 / 5.0;
            this._path.reset();
            this._path.moveTo(0.0f, 0.0f);
            this._path.lineTo(0.0f, (float)d4);
            this._path.lineTo((float)(-d2), (float)d4);
            this._path.lineTo((float)(-d2), (float)(-d3 + d4));
            this._path.lineTo(0.0f, (float)(-d3 + d4));
            this._path.lineTo(0.0f, (float)(-d3 + d4 + d4));
            this._path.lineTo((float)(-d5), (float)(-d3 + d4 + d4));
            this._path.lineTo((float)(-d5), (float)(-d3 + d4 + 3.0));
            this._path.lineTo((float)(-d2 + 3.0), (float)(-d3 + d4 + 3.0));
            this._path.lineTo((float)(-d2 + 3.0), (float)(d4 - 3.0));
            this._path.lineTo((float)(-d5), (float)(d4 - 3.0));
            this._path.lineTo((float)(-d5), 0.0f);
            this._path.closePath();
            this._pathNode.setPathTo(this._path);
        }
    }

    private static class HandleNode
    extends PComposite {
        private static final Stroke STROKE = new BasicStroke(1.0f);
        private static final Color STROKE_COLOR = Color.BLACK;
        private static final Color FILL_COLOR = new Color(85, 14, 14);

        public HandleNode(PDimension pDimension) {
            double d = pDimension.getWidth();
            double d2 = pDimension.getHeight();
            PPath pPath = new PPath(new RoundRectangle2D.Double(0.0, 0.0, d, 0.25 * d2, d / 2.0, d / 2.0));
            pPath.setStroke(STROKE);
            pPath.setStrokePaint(STROKE_COLOR);
            pPath.setPaint(FILL_COLOR);
            pPath.setOffset(0.0, 0.0);
            PPath pPath2 = new PPath(new RoundRectangle2D.Double(0.0, 0.0, d, 0.75 * d2, d / 2.0, d / 2.0));
            pPath2.setStroke(STROKE);
            pPath2.setStrokePaint(STROKE_COLOR);
            pPath2.setPaint(FILL_COLOR);
            pPath2.setOffset(0.0, pPath.getFullBoundsReference().getHeight());
            this.addChild(pPath);
            this.addChild(pPath2);
        }
    }

    private static class ValueNode
    extends PComposite {
        private JLabel _thicknessLabel;
        private PSwing _pswing;
        private boolean _englishUnits;
        private String _units;

        public ValueNode(Font font, Border border, boolean bl) {
            this._englishUnits = bl;
            this._units = bl ? GlaciersStrings.UNITS_FEET : GlaciersStrings.UNITS_METERS;
            this._thicknessLabel = new JLabel("?");
            this._thicknessLabel.setFont(font);
            JPanel jPanel = new JPanel();
            jPanel.setBorder(border);
            EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
            easyGridBagLayout.setAnchor(13);
            jPanel.setLayout(easyGridBagLayout);
            easyGridBagLayout.addComponent(this._thicknessLabel, 0, 0);
            this._pswing = new PSwing(jPanel);
            this.addChild(this._pswing);
        }

        public void setThickness(double d) {
            if (this._englishUnits) {
                d = UnitsConverter.metersToFeet(d);
            }
            this.setThickness(ICE_THICKNESS_FORMAT.format(d));
        }

        public void setThickness(String string) {
            String string2 = string + " " + this._units;
            this._thicknessLabel.setText(string2);
            this._pswing.updateBounds();
        }

        public void setEnglishUnits(boolean bl) {
            this._englishUnits = bl;
            this._units = bl ? GlaciersStrings.UNITS_FEET : GlaciersStrings.UNITS_METERS;
        }
    }
}

