/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view.tools;

import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.glaciers.GlaciersConstants;
import edu.colorado.phet.glaciers.GlaciersImages;
import edu.colorado.phet.glaciers.GlaciersStrings;
import edu.colorado.phet.glaciers.model.GlacialBudgetMeter;
import edu.colorado.phet.glaciers.model.Glacier;
import edu.colorado.phet.glaciers.model.Movable;
import edu.colorado.phet.glaciers.util.UnitsConverter;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.colorado.phet.glaciers.view.tools.AbstractToolNode;
import edu.colorado.phet.glaciers.view.tools.AbstractToolOriginNode;
import edu.colorado.phet.glaciers.view.tools.TrashCanDelegate;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolox.nodes.PComposite;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class GlacialBudgetMeterNode
extends AbstractToolNode {
    private static final NumberFormat ELEVATION_FORMAT = new DefaultDecimalFormat("0");
    private static final NumberFormat ACCUMULATION_FORMAT = new DefaultDecimalFormat("0.0");
    private static final NumberFormat ABLATION_FORMAT = new DefaultDecimalFormat("0.0");
    private static final NumberFormat GLACIAL_BUDGET_FORMAT = new DefaultDecimalFormat("0.0");
    private final GlacialBudgetMeter _glacialBudgetMeter;
    private final Glacier _glacier;
    private final GlacialBudgetMeter.GlacialBudgetMeterListener _glacialBudgetMeterListener;
    private final Glacier.GlacierListener _glacierListener;
    private final Movable.MovableListener _movableListener;
    private final ValueNode _valueNode;

    public GlacialBudgetMeterNode(GlacialBudgetMeter glacialBudgetMeter, Glacier glacier, GlaciersModelViewTransform glaciersModelViewTransform, TrashCanDelegate trashCanDelegate, boolean bl) {
        super(glacialBudgetMeter, glaciersModelViewTransform, trashCanDelegate);
        this._glacialBudgetMeter = glacialBudgetMeter;
        this._glacier = glacier;
        this._glacialBudgetMeterListener = new GlacialBudgetMeter.GlacialBudgetMeterListener(){

            public void accumulationChanged() {
                GlacialBudgetMeterNode.this.update();
            }

            public void ablationChanged() {
                GlacialBudgetMeterNode.this.update();
            }

            public void glacialBudgetChanged() {
                GlacialBudgetMeterNode.this.update();
            }
        };
        this._glacialBudgetMeter.addGlacialBudgetMeterListener(this._glacialBudgetMeterListener);
        this._movableListener = new Movable.MovableAdapter(){

            public void positionChanged() {
                GlacialBudgetMeterNode.this.update();
            }
        };
        this._glacialBudgetMeter.addMovableListener(this._movableListener);
        this._glacierListener = new Glacier.GlacierAdapter(){

            public void iceThicknessChanged() {
                GlacialBudgetMeterNode.this.update();
            }
        };
        this._glacier.addGlacierListener(this._glacierListener);
        AbstractToolOriginNode.LeftToolOriginNode leftToolOriginNode = new AbstractToolOriginNode.LeftToolOriginNode();
        this.addChild(leftToolOriginNode);
        leftToolOriginNode.setOffset(0.0, 0.0);
        MeterNode meterNode = new MeterNode();
        this.addChild(meterNode);
        meterNode.setOffset(leftToolOriginNode.getFullBoundsReference().getMaxX() + 2.0, -meterNode.getFullBoundsReference().getHeight() / 2.0);
        this._valueNode = new ValueNode(GlacialBudgetMeterNode.getValueFont(), GlacialBudgetMeterNode.getValueBorder(), bl);
        this.addChild(this._valueNode);
        this._valueNode.setOffset(meterNode.getFullBounds().getMaxX() + 2.0, -this._valueNode.getFullBounds().getHeight() / 2.0);
        this._valueNode.setValuesUnknown();
    }

    public void cleanup() {
        this._glacialBudgetMeter.removeGlacialBudgetMeterListener(this._glacialBudgetMeterListener);
        this._glacialBudgetMeter.removeMovableListener(this._movableListener);
        this._glacier.removeGlacierListener(this._glacierListener);
        super.cleanup();
    }

    public void setEnglishUnits(boolean bl) {
        this._valueNode.setEnglishUnits(bl);
        this.update();
    }

    private void update() {
        double d = this._glacier.getSurfaceElevation(this._glacialBudgetMeter.getX());
        if (this._glacialBudgetMeter.getY() == d) {
            this._valueNode.setValues(this._glacialBudgetMeter.getPosition().getY(), this._glacialBudgetMeter.getAccumulation(), this._glacialBudgetMeter.getAblation(), this._glacialBudgetMeter.getGlacialBudget());
        } else {
            this._valueNode.setValuesUnknown();
        }
    }

    public static Image createImage() {
        return GlaciersImages.GLACIAL_BUDGET_METER;
    }

    private static class MeterNode
    extends PComposite {
        public MeterNode() {
            PImage pImage = new PImage(GlaciersImages.GLACIAL_BUDGET_METER);
            this.addChild(pImage);
        }
    }

    private static class ValueNode
    extends PComposite {
        private JLabel _elevationLabel;
        private JLabel _accumulationLabel;
        private JLabel _ablationLabel;
        private JLabel _glacialBudgetLabel;
        private PSwing _pswing;
        private boolean _englishUnits;
        private String _units;

        public ValueNode(Font font, Border border, boolean bl) {
            this._englishUnits = bl;
            this._units = bl ? GlaciersStrings.UNITS_FEET_PER_YEAR : GlaciersStrings.UNITS_METERS_PER_YEAR;
            JLabel jLabel = new JLabel(GlaciersStrings.LABEL_ELEVATION + ":");
            jLabel.setFont(font);
            this._elevationLabel = new JLabel("0");
            this._elevationLabel.setFont(font);
            JLabel jLabel2 = new JLabel(GlaciersStrings.LABEL_ACCUMULATION + ":");
            jLabel2.setFont(font);
            this._accumulationLabel = new JLabel("0");
            this._accumulationLabel.setFont(font);
            this._accumulationLabel.setForeground(GlaciersConstants.ACCUMULATION_COLOR);
            JLabel jLabel3 = new JLabel(GlaciersStrings.LABEL_ABLATION + ":");
            jLabel3.setFont(font);
            this._ablationLabel = new JLabel("0");
            this._ablationLabel.setFont(font);
            this._ablationLabel.setForeground(GlaciersConstants.ABLATION_COLOR);
            JLabel jLabel4 = new JLabel(GlaciersStrings.LABEL_GLACIAL_BUDGET + ":");
            jLabel4.setFont(font);
            this._glacialBudgetLabel = new JLabel("0");
            this._glacialBudgetLabel.setFont(font);
            this._glacialBudgetLabel.setForeground(GlaciersConstants.GLACIAL_BUDGET_COLOR);
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.WHITE);
            jPanel.setBorder(border);
            EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
            jPanel.setLayout(easyGridBagLayout);
            int n = 0;
            int n2 = 0;
            easyGridBagLayout.addAnchoredComponent(jLabel2, n, n2++, 13);
            easyGridBagLayout.addAnchoredComponent(this._accumulationLabel, n++, n2++, 17);
            n2 = 0;
            easyGridBagLayout.addAnchoredComponent(jLabel3, n, n2++, 13);
            easyGridBagLayout.addAnchoredComponent(this._ablationLabel, n++, n2++, 17);
            n2 = 0;
            easyGridBagLayout.addAnchoredComponent(jLabel4, n, n2++, 13);
            easyGridBagLayout.addAnchoredComponent(this._glacialBudgetLabel, n++, n2++, 17);
            this._pswing = new PSwing(jPanel);
            this.addChild(this._pswing);
        }

        public void setValues(double d, double d2, double d3, double d4) {
            if (this._englishUnits) {
                this._elevationLabel.setText(ELEVATION_FORMAT.format(UnitsConverter.metersToFeet(d)) + " " + this._units);
                this._accumulationLabel.setText(ACCUMULATION_FORMAT.format(UnitsConverter.metersToFeet(d2)) + " " + this._units);
                this._ablationLabel.setText(ABLATION_FORMAT.format(UnitsConverter.metersToFeet(d3)) + " " + this._units);
                this._glacialBudgetLabel.setText(GLACIAL_BUDGET_FORMAT.format(UnitsConverter.metersToFeet(d4)) + " " + this._units);
            } else {
                this._elevationLabel.setText(ELEVATION_FORMAT.format(d) + " " + this._units);
                this._accumulationLabel.setText(ACCUMULATION_FORMAT.format(d2) + " " + this._units);
                this._ablationLabel.setText(ABLATION_FORMAT.format(d3) + " " + this._units);
                this._glacialBudgetLabel.setText(GLACIAL_BUDGET_FORMAT.format(d4) + " " + this._units);
            }
            this._pswing.updateBounds();
        }

        public void setValuesUnknown() {
            this._elevationLabel.setText("? " + this._units);
            this._accumulationLabel.setText("? " + this._units);
            this._ablationLabel.setText("? " + this._units);
            this._glacialBudgetLabel.setText("? " + this._units);
            this._pswing.updateBounds();
        }

        public void setEnglishUnits(boolean bl) {
            this._englishUnits = bl;
            this._units = bl ? GlaciersStrings.UNITS_FEET_PER_YEAR : GlaciersStrings.UNITS_METERS_PER_YEAR;
        }
    }
}

