/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view.tools;

import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.glaciers.GlaciersImages;
import edu.colorado.phet.glaciers.GlaciersStrings;
import edu.colorado.phet.glaciers.model.GPSReceiver;
import edu.colorado.phet.glaciers.model.Movable;
import edu.colorado.phet.glaciers.util.UnitsConverter;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.colorado.phet.glaciers.view.tools.AbstractToolNode;
import edu.colorado.phet.glaciers.view.tools.AbstractToolOriginNode;
import edu.colorado.phet.glaciers.view.tools.TrashCanDelegate;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolox.nodes.PComposite;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class GPSReceiverNode
extends AbstractToolNode {
    private static final NumberFormat DISTANCE_FORMAT = new DefaultDecimalFormat("0");
    private static final NumberFormat ELEVATION_FORMAT = new DefaultDecimalFormat("0");
    private final GPSReceiver _gps;
    private final Movable.MovableListener _movableListener;
    private final ValueNode _valueNode;

    public GPSReceiverNode(GPSReceiver gPSReceiver, GlaciersModelViewTransform glaciersModelViewTransform, TrashCanDelegate trashCanDelegate, boolean bl) {
        super(gPSReceiver, glaciersModelViewTransform, trashCanDelegate);
        this._gps = gPSReceiver;
        this._movableListener = new Movable.MovableAdapter(){

            public void positionChanged() {
                GPSReceiverNode.this.update();
            }
        };
        this._gps.addMovableListener(this._movableListener);
        AbstractToolOriginNode.LeftToolOriginNode leftToolOriginNode = new AbstractToolOriginNode.LeftToolOriginNode();
        this.addChild(leftToolOriginNode);
        leftToolOriginNode.setOffset(0.0, 0.0);
        ReceiverNode receiverNode = new ReceiverNode();
        this.addChild(receiverNode);
        receiverNode.setOffset(leftToolOriginNode.getFullBounds().getMaxX() + 2.0, -22.0);
        this._valueNode = new ValueNode(GPSReceiverNode.getValueFont(), GPSReceiverNode.getValueBorder(), bl);
        this.addChild(this._valueNode);
        this._valueNode.setOffset(receiverNode.getFullBounds().getMaxX() + 2.0, -leftToolOriginNode.getFullBounds().getHeight() / 2.0);
        this.update();
    }

    public void cleanup() {
        this._gps.removeMovableListener(this._movableListener);
        super.cleanup();
    }

    public void setEnglishUnits(boolean bl) {
        this._valueNode.setEnglishUnits(bl);
        this.update();
    }

    private void update() {
        this._valueNode.setCoordinates(this._gps.getPositionReference());
    }

    public static Image createImage() {
        return new ReceiverNode().toImage();
    }

    private static class ReceiverNode
    extends PComposite {
        public ReceiverNode() {
            PImage pImage = new PImage(GlaciersImages.GPS_RECEIVER);
            this.addChild(pImage);
        }
    }

    private static class ValueNode
    extends PComposite {
        private JLabel _distanceLabel;
        private JLabel _elevationLabel;
        private PSwing _pswing;
        private boolean _englishUnits;
        private String _units;

        public ValueNode(Font font, Border border, boolean bl) {
            this._englishUnits = bl;
            this._units = bl ? GlaciersStrings.UNITS_FEET : GlaciersStrings.UNITS_METERS;
            ArrowNode arrowNode = new ArrowNode(new Point2D.Double(0.0, 0.0), new Point2D.Double(10.0, 0.0), 5.0, 8.0, 2.0);
            arrowNode.setStroke(null);
            arrowNode.setPaint(Color.BLACK);
            JLabel jLabel = new JLabel(new ImageIcon(arrowNode.toImage()));
            ArrowNode arrowNode2 = new ArrowNode(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, -10.0), 5.0, 8.0, 2.0);
            arrowNode2.setStroke(null);
            arrowNode2.setPaint(Color.BLACK);
            JLabel jLabel2 = new JLabel(new ImageIcon(arrowNode2.toImage()));
            this._distanceLabel = new JLabel("?");
            this._distanceLabel.setFont(font);
            this._elevationLabel = new JLabel("?");
            this._elevationLabel.setFont(font);
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.WHITE);
            jPanel.setBorder(border);
            EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
            easyGridBagLayout.setAnchor(13);
            jPanel.setLayout(easyGridBagLayout);
            easyGridBagLayout.addComponent(jLabel, 0, 0);
            easyGridBagLayout.addComponent(this._distanceLabel, 0, 1);
            easyGridBagLayout.addComponent(jLabel2, 1, 0);
            easyGridBagLayout.addComponent(this._elevationLabel, 1, 1);
            this._pswing = new PSwing(jPanel);
            this.addChild(this._pswing);
        }

        public void setCoordinates(Point2D point2D) {
            double d = point2D.getX();
            double d2 = point2D.getY();
            if (this._englishUnits) {
                d = UnitsConverter.metersToFeet(d);
                d2 = UnitsConverter.metersToFeet(d2);
            }
            this._distanceLabel.setText(GlaciersStrings.LABEL_DISTANCE + ": " + DISTANCE_FORMAT.format(d) + " " + this._units);
            this._elevationLabel.setText(GlaciersStrings.LABEL_ELEVATION + ": " + ELEVATION_FORMAT.format(d2) + " " + this._units);
        }

        public void setEnglishUnits(boolean bl) {
            this._englishUnits = bl;
            this._units = bl ? GlaciersStrings.UNITS_FEET : GlaciersStrings.UNITS_METERS;
        }
    }
}

