/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view.tools;

import edu.colorado.phet.common.piccolophet.nodes.ImageButtonNode;
import edu.colorado.phet.glaciers.GlaciersImages;
import edu.colorado.phet.glaciers.model.BoreholeDrill;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.colorado.phet.glaciers.view.tools.AbstractToolNode;
import edu.colorado.phet.glaciers.view.tools.TrashCanDelegate;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class BoreholeDrillNode
extends AbstractToolNode {
    public BoreholeDrillNode(final BoreholeDrill boreholeDrill, GlaciersModelViewTransform glaciersModelViewTransform, TrashCanDelegate trashCanDelegate) {
        super(boreholeDrill, glaciersModelViewTransform, trashCanDelegate);
        DrillNode drillNode = new DrillNode();
        this.addChild(drillNode);
        ButtonNode buttonNode = new ButtonNode();
        this.addChild(buttonNode);
        drillNode.setOffset(-8.0, -drillNode.getFullBoundsReference().getHeight());
        buttonNode.setOffset(-11.0, -drillNode.getFullBoundsReference().getHeight() + 8.0);
        buttonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boreholeDrill.drill();
            }
        });
    }

    public static Image createImage() {
        PImage pImage = new PImage(GlaciersImages.BOREHOLE_DRILL);
        pImage.scale(0.65);
        return pImage.toImage();
    }

    private static class ButtonNode
    extends ImageButtonNode {
        public ButtonNode() {
            super(GlaciersImages.BOREHOLE_DRILL_OFF_BUTTON, GlaciersImages.BOREHOLE_DRILL_ON_BUTTON);
        }
    }

    private static class DrillNode
    extends PComposite {
        public DrillNode() {
            PImage pImage = new PImage(GlaciersImages.BOREHOLE_DRILL);
            this.addChild(pImage);
        }
    }
}

