/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view.tools;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.glaciers.model.AbstractTool;
import edu.colorado.phet.glaciers.model.Movable;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.colorado.phet.glaciers.view.tools.TrashCanDelegate;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public abstract class AbstractToolNode
extends PNode {
    private static final Font FONT = new PhetFont(10);
    private static final Border VALUE_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 1), BorderFactory.createEmptyBorder(1, 2, 1, 2));
    private final AbstractTool _tool;
    private final GlaciersModelViewTransform _mvt;
    private final TrashCanDelegate _trashCan;
    private final Movable.MovableListener _movableListener;
    private final Point2D _pModel = new Point2D.Double();
    private final Point2D _pView = new Point2D.Double();
    private boolean _draggingEnabled;

    public AbstractToolNode(AbstractTool abstractTool, GlaciersModelViewTransform glaciersModelViewTransform, TrashCanDelegate trashCanDelegate) {
        this._tool = abstractTool;
        this._mvt = glaciersModelViewTransform;
        this._trashCan = trashCanDelegate;
        this._movableListener = new Movable.MovableListener(){

            public void positionChanged() {
                AbstractToolNode.this.updatePosition();
            }

            public void orientationChanged() {
                AbstractToolNode.this.updateOrientation();
            }
        };
        this._tool.addMovableListener(this._movableListener);
        this._draggingEnabled = true;
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new PDragEventHandler(){
            private double _xOffset;
            private double _yOffset;

            protected void startDrag(PInputEvent pInputEvent) {
                if (AbstractToolNode.this._draggingEnabled) {
                    AbstractToolNode.this.startDrag();
                    AbstractToolNode.this.getTool().setDragging(true);
                    AbstractToolNode.this._mvt.modelToView(AbstractToolNode.this._tool.getPosition(), AbstractToolNode.this._pView);
                    this._xOffset = pInputEvent.getPosition().getX() - AbstractToolNode.this._pView.getX();
                    this._yOffset = pInputEvent.getPosition().getY() - AbstractToolNode.this._pView.getY();
                    super.startDrag(pInputEvent);
                }
            }

            protected void drag(PInputEvent pInputEvent) {
                if (AbstractToolNode.this._draggingEnabled) {
                    double d = pInputEvent.getPosition().getX() - this._xOffset;
                    double d2 = pInputEvent.getPosition().getY() - this._yOffset;
                    AbstractToolNode.this._mvt.viewToModel(d, d2, AbstractToolNode.this._pModel);
                    AbstractToolNode.this._tool.setPosition(AbstractToolNode.this._pModel);
                }
            }

            protected void endDrag(PInputEvent pInputEvent) {
                if (AbstractToolNode.this._draggingEnabled) {
                    if (AbstractToolNode.this._trashCan.isInTrash(pInputEvent.getPosition())) {
                        AbstractToolNode.this._trashCan.delete(AbstractToolNode.this, pInputEvent.getPosition());
                    } else {
                        AbstractToolNode.this.getTool().setDragging(false);
                    }
                    super.endDrag(pInputEvent);
                    AbstractToolNode.this.endDrag();
                }
            }
        });
        this.updatePosition();
    }

    protected void startDrag() {
    }

    protected void endDrag() {
    }

    public void cleanup() {
        this._tool.removeMovableListener(this._movableListener);
    }

    public AbstractTool getTool() {
        return this._tool;
    }

    public void setEnglishUnits(boolean bl) {
    }

    protected GlaciersModelViewTransform getModelViewTransform() {
        return this._mvt;
    }

    protected void updatePosition() {
        this._mvt.modelToView(this._tool.getPositionReference(), this._pView);
        this.setOffset(this._pView);
    }

    protected void updateOrientation() {
    }

    protected static Font getValueFont() {
        return FONT;
    }

    protected static Border getValueBorder() {
        return VALUE_BORDER;
    }
}

