/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view.tools;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.glaciers.model.AbstractTool;
import edu.colorado.phet.glaciers.model.IToolProducer;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.geom.Point2D;
import javax.swing.plaf.basic.BasicHTML;

public abstract class AbstractToolIconNode
extends PNode {
    private static final Font LABEL_FONT = new PhetFont(12);
    private static final Color LABEL_COLOR = Color.BLACK;
    private static final Point2D DEFAULT_DRAG_OFFSET = new Point2D.Double(0.0, 0.0);

    public AbstractToolIconNode(Image image, String string) {
        PImage pImage = new PImage(image);
        pImage.setOffset(0.0, 0.0);
        this.addChild(pImage);
        if (string != null) {
            PNode pNode = null;
            if (BasicHTML.isHTMLString(string)) {
                HTMLNode hTMLNode = new HTMLNode(string);
                hTMLNode.setFont(LABEL_FONT);
                hTMLNode.setHTMLColor(LABEL_COLOR);
                pNode = hTMLNode;
            } else {
                PText pText = new PText(string);
                pText.setFont(LABEL_FONT);
                pText.setTextPaint(LABEL_COLOR);
                pNode = pText;
            }
            this.addChild(pNode);
            if (pImage.getWidth() > pNode.getWidth()) {
                pImage.setOffset(0.0, 0.0);
                pNode.setOffset(pImage.getX() + (pImage.getWidth() - pNode.getWidth()) / 2.0, pImage.getY() + pImage.getHeight() + 2.0);
            } else {
                pNode.setOffset(0.0, pImage.getY() + pImage.getHeight() + 2.0);
                pImage.setOffset(pNode.getX() + (pNode.getWidth() - pImage.getWidth()) / 2.0, 0.0);
            }
        }
    }

    protected static abstract class InteractiveToolIconNode
    extends AbstractToolIconNode {
        private final IToolProducer _toolProducer;
        private final GlaciersModelViewTransform _mvt;
        private final Point2D _pModel;
        private final Point2D _pView;

        public InteractiveToolIconNode(Image image, IToolProducer iToolProducer, GlaciersModelViewTransform glaciersModelViewTransform) {
            this(image, null, iToolProducer, glaciersModelViewTransform);
        }

        public InteractiveToolIconNode(Image image, String string, IToolProducer iToolProducer, GlaciersModelViewTransform glaciersModelViewTransform) {
            super(image, string);
            this._toolProducer = iToolProducer;
            this._mvt = glaciersModelViewTransform;
            this._pModel = new Point2D.Double();
            this._pView = new Point2D.Double();
            this.addInputEventListener(new CursorHandler());
            this.addInputEventListener(new PDragEventHandler(){
                private AbstractTool _tool = null;

                protected void startDrag(PInputEvent pInputEvent) {
                    Point2D point2D = InteractiveToolIconNode.this.getDragOffsetReference();
                    InteractiveToolIconNode.this._pView.setLocation(pInputEvent.getPosition().getX() + point2D.getX(), pInputEvent.getPosition().getY() + point2D.getY());
                    InteractiveToolIconNode.this._mvt.viewToModel(InteractiveToolIconNode.this._pView, InteractiveToolIconNode.this._pModel);
                    this._tool = InteractiveToolIconNode.this.createTool(InteractiveToolIconNode.this._pModel);
                    this._tool.setDragging(true);
                    super.startDrag(pInputEvent);
                }

                protected void drag(PInputEvent pInputEvent) {
                    Point2D point2D = InteractiveToolIconNode.this.getDragOffsetReference();
                    InteractiveToolIconNode.this._pView.setLocation(pInputEvent.getPosition().getX() + point2D.getX(), pInputEvent.getPosition().getY() + point2D.getY());
                    InteractiveToolIconNode.this._mvt.viewToModel(InteractiveToolIconNode.this._pView, InteractiveToolIconNode.this._pModel);
                    this._tool.setPosition(InteractiveToolIconNode.this._pModel);
                }

                protected void endDrag(PInputEvent pInputEvent) {
                    super.endDrag(pInputEvent);
                    this._tool.setDragging(false);
                    this._tool = null;
                }
            });
        }

        protected IToolProducer getToolProducer() {
            return this._toolProducer;
        }

        protected abstract AbstractTool createTool(Point2D var1);

        protected Point2D getDragOffsetReference() {
            return DEFAULT_DRAG_OFFSET;
        }
    }
}

