/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view;

import edu.colorado.phet.glaciers.model.Viewport;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Rectangle2D;

public class ViewportNode
extends PPath {
    private static final Color STROKE_COLOR = Color.BLACK;
    private final Viewport _viewport;
    private final GlaciersModelViewTransform _mvt;

    public ViewportNode(Viewport viewport, float f, GlaciersModelViewTransform glaciersModelViewTransform) {
        this._viewport = viewport;
        this._viewport.addViewportListener(new Viewport.ViewportListener(){

            public void boundsChanged() {
                ViewportNode.this.updateRectangle();
            }
        });
        this._mvt = glaciersModelViewTransform;
        this.setPaint(null);
        float f2 = 4.0f * f;
        this.setStroke(new BasicStroke(f, 0, 2, 0.0f, new float[]{f2, f2}, 0.0f));
        this.setStrokePaint(STROKE_COLOR);
        this.updateRectangle();
    }

    private void updateRectangle() {
        Rectangle2D rectangle2D = this._viewport.getBoundsReference();
        Rectangle2D rectangle2D2 = this._mvt.modelToView(rectangle2D);
        this.setPathTo(rectangle2D2);
    }
}

