/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view;

import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.glaciers.GlaciersConstants;
import edu.colorado.phet.glaciers.GlaciersImages;
import edu.colorado.phet.glaciers.model.Climate;
import edu.colorado.phet.glaciers.model.Glacier;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.colorado.phet.glaciers.view.IceNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class SnowfallNode
extends PhetPNode {
    private static final Color BASE_COLOR = new Color(255, 255, 255);
    private static final Color NO_SNOW_COLOR = ColorUtils.createColor(BASE_COLOR, 0);
    private final Glacier _glacier;
    private final Glacier.GlacierListener _glacierListener;
    private final Climate.ClimateListener _climateListener;
    private final GlaciersModelViewTransform _mvt;
    private final Rectangle2D _worldBounds;
    private final PPath _pathNode;
    private final GeneralPath _path;
    private final Point2D _pModel;
    private final Point2D _pView;

    public SnowfallNode(Glacier glacier, GlaciersModelViewTransform glaciersModelViewTransform) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._glacier = glacier;
        this._mvt = glaciersModelViewTransform;
        this._worldBounds = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        this._path = new GeneralPath();
        this._pModel = new Point2D.Double();
        this._pView = new Point2D.Double();
        this._pathNode = new PhetPPath();
        this._pathNode.setStroke(null);
        this.addChild(this._pathNode);
        this._glacierListener = new Glacier.GlacierAdapter(){

            public void iceThicknessChanged() {
                SnowfallNode.this.updateShape();
            }
        };
        this._glacier.addGlacierListener(this._glacierListener);
        this._climateListener = new Climate.ClimateAdapter(){

            public void snowfallChanged() {
                SnowfallNode.this.updatePaint();
            }
        };
        this._glacier.getClimate().addClimateListener(this._climateListener);
        this.updateShape();
        this.updatePaint();
    }

    public void setVisible(boolean bl) {
        if (bl != this.getVisible()) {
            super.setVisible(bl);
            if (bl) {
                this.updateShape();
                this.updatePaint();
            }
        }
    }

    public void setWorldBounds(Rectangle2D rectangle2D) {
        if (!rectangle2D.equals(this._worldBounds)) {
            double d = rectangle2D.getY() - 1500.0;
            this._worldBounds.setFrame(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), d);
            this.updateShape();
            this.updatePaint();
        }
    }

    private void updateShape() {
        if (this.getVisible()) {
            double d = IceNode.getDx();
            double d2 = this._worldBounds.getMinX() - d;
            double d3 = this._worldBounds.getMaxX() + d;
            double d4 = this._worldBounds.getY() + 20.0;
            this._path.reset();
            this._pModel.setLocation(d3, d4);
            this._mvt.modelToView(this._pModel, this._pView);
            this._path.moveTo((float)this._pView.getX(), (float)this._pView.getY());
            this._pModel.setLocation(d2, d4);
            this._mvt.modelToView(this._pModel, this._pView);
            this._path.lineTo((float)this._pView.getX(), (float)this._pView.getY());
            double d5 = 0.0;
            for (double d6 = d2; d6 <= d3; d6 += d) {
                d5 = this._glacier.getSurfaceElevation(d6);
                this._pModel.setLocation(d6, d5);
                this._mvt.modelToView(this._pModel, this._pView);
                this._path.lineTo((float)this._pView.getX(), (float)this._pView.getY());
            }
            this._path.closePath();
            this._pathNode.setPathTo(this._path);
        }
    }

    private void updatePaint() {
        if (this.getVisible()) {
            double d = this._glacier.getClimate().getSnowfall();
            assert (GlaciersConstants.SNOWFALL_RANGE.contains(d));
            double d2 = GlaciersConstants.SNOWFALL_RANGE.getMin();
            double d3 = GlaciersConstants.SNOWFALL_RANGE.getMax();
            double d4 = (d - d2) / (d3 - d2);
            int n = (int)(d4 * 255.0);
            Rectangle2D.Double double_ = new Rectangle2D.Double(this._worldBounds.getX(), 4800.0, this._worldBounds.getWidth(), 3300.0);
            Rectangle2D rectangle2D = this._mvt.modelToView(double_);
            Color color = ColorUtils.createColor(BASE_COLOR, n);
            GradientPaint gradientPaint = new GradientPaint((float)rectangle2D.getX(), (float)rectangle2D.getMinY(), color, (float)rectangle2D.getX(), (float)rectangle2D.getMaxY(), NO_SNOW_COLOR);
            this._pathNode.setPaint(gradientPaint);
        }
    }

    public static Icon createIcon() {
        return new ImageIcon(GlaciersImages.SNOWFLAKE);
    }
}

