/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view;

import edu.colorado.phet.glaciers.GlaciersConstants;
import edu.colorado.phet.glaciers.model.Glacier;
import edu.colorado.phet.glaciers.model.Valley;
import edu.colorado.phet.glaciers.util.UnitsConverter;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class SnowPatchNode
extends PComposite {
    private static final double THICKNESS_AT_TERMINUS = UnitsConverter.feetToMeters(50.0);
    private final Glacier _glacier;
    private final Glacier.GlacierListener _glacierListener;
    private final GlaciersModelViewTransform _mvt;
    private final GeneralPath _crossSectionPath;
    private final GeneralPath _surfacePath;
    private final PPath _crossSectionNode;
    private final PPath _surfaceNode;
    private final Point2D _pModel;
    private final Point2D _pView;

    public SnowPatchNode(Glacier glacier, GlaciersModelViewTransform glaciersModelViewTransform) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._glacier = glacier;
        this._glacierListener = new Glacier.GlacierAdapter(){

            public void iceThicknessChanged() {
                SnowPatchNode.this.update();
            }
        };
        this._glacier.addGlacierListener(this._glacierListener);
        this._mvt = glaciersModelViewTransform;
        this._crossSectionPath = new GeneralPath();
        this._crossSectionNode = new PPath(this._crossSectionPath);
        this._crossSectionNode.setPaint(GlaciersConstants.SNOW_PATCH_CROSS_SECTION_COLOR);
        this._crossSectionNode.setStroke(null);
        this.addChild(this._crossSectionNode);
        this._surfacePath = new GeneralPath();
        this._surfaceNode = new PPath(this._surfacePath);
        this._surfaceNode.setPaint(GlaciersConstants.SNOW_PATCH_SURFACE_COLOR);
        this._surfaceNode.setStroke(null);
        this.addChild(this._surfaceNode);
        this._pModel = new Point2D.Double();
        this._pView = new Point2D.Double();
        this.update();
    }

    private void update() {
        double d;
        double d2;
        double d3;
        this._crossSectionPath.reset();
        this._surfacePath.reset();
        double d4 = this._glacier.getClimate().getELA();
        double d5 = this._glacier.getTerminusY();
        if (d4 < d5 && (d3 = (d2 = this._glacier.getValley().getX(d4)) - (d = this._glacier.getTerminusX())) > 0.0) {
            double d6;
            double d7;
            Valley valley = this._glacier.getValley();
            assert (THICKNESS_AT_TERMINUS > 0.0);
            double d8 = (THICKNESS_AT_TERMINUS - 0.0) * 80.0 / d3;
            double d9 = THICKNESS_AT_TERMINUS;
            for (d7 = d; d7 <= d2; d7 += 80.0) {
                this._pModel.setLocation(d7, valley.getElevation(d7) + d9);
                this._mvt.modelToView(this._pModel, this._pView);
                if (d7 == d) {
                    this._crossSectionPath.moveTo((float)this._pView.getX(), (float)this._pView.getY());
                    this._surfacePath.moveTo((float)this._pView.getX(), (float)this._pView.getY());
                } else {
                    this._crossSectionPath.lineTo((float)this._pView.getX(), (float)this._pView.getY());
                    this._surfacePath.lineTo((float)this._pView.getX(), (float)this._pView.getY());
                }
                if (d3 > 80.0 && (d6 = d2 - d7) > 0.1 && d6 < 80.0) {
                    d7 = d2 - 80.0;
                }
                d9 = Math.max(d9 - d8, 0.0);
            }
            for (d7 = d2; d7 >= d; d7 -= 80.0) {
                double d10;
                this._pModel.setLocation(d7, this._glacier.getValley().getElevation(d7));
                this._mvt.modelToView(this._pModel, this._pView);
                this._crossSectionPath.lineTo((float)this._pView.getX(), (float)this._pView.getY());
                d6 = d7 + 500.0;
                double d11 = valley.getElevation(d7) + 250.0;
                this._pModel.setLocation(d6, d11);
                this._mvt.modelToView(this._pModel, this._pView);
                this._surfacePath.lineTo((float)this._pView.getX(), (float)this._pView.getY());
                if (!(d3 > 80.0) || !((d10 = d7 - d) > 0.1) || !(d10 < 80.0)) continue;
                d7 = d + 80.0;
            }
            this._crossSectionPath.closePath();
            this._surfacePath.closePath();
        }
        this._crossSectionNode.setPathTo(this._crossSectionPath);
        this._surfaceNode.setPathTo(this._surfacePath);
    }
}

