/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view;

import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.glaciers.GlaciersImages;
import edu.colorado.phet.glaciers.model.Viewport;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.geom.Rectangle2D;

public class PanControlNode
extends PImage {
    private final Viewport _birdsEyeViewport;
    private final Viewport _zoomedViewport;
    private final GlaciersModelViewTransform _mvt;
    private final double _zoomedViewportMaxX;

    public PanControlNode(Viewport viewport, Viewport viewport2, GlaciersModelViewTransform glaciersModelViewTransform, double d) {
        super(GlaciersImages.PAN_CHARACTER);
        this._birdsEyeViewport = viewport;
        this._birdsEyeViewport.addViewportListener(new Viewport.ViewportListener(){

            public void boundsChanged() {
                PanControlNode.this.updateScale();
                PanControlNode.this.updateOffset();
            }
        });
        this._zoomedViewport = viewport2;
        this._zoomedViewport.addViewportListener(new Viewport.ViewportListener(){

            public void boundsChanged() {
                PanControlNode.this.updateOffset();
            }
        });
        this._mvt = glaciersModelViewTransform;
        this._zoomedViewportMaxX = d;
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new PDragEventHandler(){
            private double _xOffset;

            protected void startDrag(PInputEvent pInputEvent) {
                Rectangle2D rectangle2D = PanControlNode.this._zoomedViewport.getBoundsReference();
                Rectangle2D rectangle2D2 = PanControlNode.this._mvt.modelToView(rectangle2D);
                this._xOffset = pInputEvent.getPosition().getX() - rectangle2D2.getX();
                super.startDrag(pInputEvent);
            }

            protected void drag(PInputEvent pInputEvent) {
                Rectangle2D rectangle2D = PanControlNode.this._zoomedViewport.getBoundsReference();
                Rectangle2D rectangle2D2 = PanControlNode.this._mvt.modelToView(rectangle2D);
                double d = pInputEvent.getPosition().getX() - this._xOffset;
                rectangle2D2.setRect(d, rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight());
                rectangle2D = PanControlNode.this._mvt.viewToModel(rectangle2D2);
                Rectangle2D rectangle2D3 = PanControlNode.this._birdsEyeViewport.getBoundsReference();
                if (rectangle2D.getX() < rectangle2D3.getX()) {
                    rectangle2D.setRect(rectangle2D3.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                } else {
                    double d2 = rectangle2D3.getMaxX();
                    if (PanControlNode.this._zoomedViewportMaxX != -1.0) {
                        d2 = Math.min(PanControlNode.this._zoomedViewportMaxX, d2);
                    }
                    if (d2 < rectangle2D.getWidth()) {
                        rectangle2D.setRect(rectangle2D3.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                    } else if (rectangle2D.getMaxX() > d2) {
                        rectangle2D.setRect(d2 - rectangle2D.getWidth(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                    }
                }
                PanControlNode.this._zoomedViewport.setBounds(rectangle2D);
            }
        });
    }

    private void updateOffset() {
        Rectangle2D rectangle2D = this._zoomedViewport.getBoundsReference();
        Rectangle2D rectangle2D2 = this._mvt.modelToView(rectangle2D);
        double d = rectangle2D2.getCenterX() - this.getFullBoundsReference().getWidth() / 2.0;
        double d2 = this._mvt.modelToView(this._birdsEyeViewport.getBoundsReference()).getMaxY() - this.getFullBoundsReference().getHeight();
        this.setOffset(d, d2);
    }

    private void updateScale() {
        this.setScale(1.0);
        double d = 0.75 * this._mvt.modelToView(this._birdsEyeViewport.getBoundsReference()).getHeight();
        double d2 = this.getFullBoundsReference().getHeight();
        double d3 = 1.0;
        d3 = d2 > d ? 1.0 - (d2 - d) / d2 : 1.0 + (d - d2) / d;
        this.setScale(d3);
    }
}

