/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class GlaciersModelViewTransform {
    private final AffineTransform _modelToViewTransform;
    private final AffineTransform _viewToModelTransform;
    private final boolean _flipSignX;
    private final boolean _flipSignY;

    public GlaciersModelViewTransform(double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
        this._flipSignX = bl;
        this._flipSignY = bl2;
        this._modelToViewTransform = new AffineTransform();
        this._modelToViewTransform.scale(d, d2);
        this._modelToViewTransform.translate(d3, d4);
        this._viewToModelTransform = new AffineTransform();
        this._viewToModelTransform.translate(-d3, -d4);
        this._viewToModelTransform.scale(1.0 / d, 1.0 / d2);
    }

    public Point2D modelToView(Point2D point2D, Point2D point2D2) {
        Point2D point2D3 = this._modelToViewTransform.transform(point2D, point2D2);
        if (this._flipSignX) {
            point2D3.setLocation(-point2D3.getX(), point2D3.getY());
        }
        if (this._flipSignY) {
            point2D3.setLocation(point2D3.getX(), -point2D3.getY());
        }
        return point2D3;
    }

    public Point2D modelToView(Point2D point2D) {
        return this.modelToView(point2D, null);
    }

    public Point2D modelToView(double d, double d2, Point2D point2D) {
        return this.modelToView(new Point2D.Double(d, d2), point2D);
    }

    public Point2D modelToView(double d, double d2) {
        return this.modelToView(d, d2, null);
    }

    public Rectangle2D modelToView(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this._modelToViewTransform.createTransformedShape(rectangle2D).getBounds2D();
        if (this._flipSignX) {
            rectangle2D2.setRect(-rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight());
        }
        if (this._flipSignY) {
            rectangle2D2.setRect(rectangle2D2.getX(), -rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight());
        }
        return rectangle2D2;
    }

    public Point2D viewToModel(Point2D point2D, Point2D point2D2) {
        Point2D point2D3 = this._viewToModelTransform.transform(point2D, point2D2);
        if (this._flipSignX) {
            point2D3.setLocation(-point2D3.getX(), point2D3.getY());
        }
        if (this._flipSignY) {
            point2D3.setLocation(point2D3.getX(), -point2D3.getY());
        }
        return point2D3;
    }

    public Point2D viewToModel(double d, double d2, Point2D point2D) {
        return this.viewToModel(new Point2D.Double(d, d2), point2D);
    }

    public Rectangle2D viewToModel(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this._viewToModelTransform.createTransformedShape(rectangle2D).getBounds2D();
        if (this._flipSignX) {
            rectangle2D2.setRect(-rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight());
        }
        if (this._flipSignY) {
            rectangle2D2.setRect(rectangle2D2.getX(), -rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight());
        }
        return rectangle2D2;
    }
}

