/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view;

import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.glaciers.GlaciersStrings;
import edu.colorado.phet.glaciers.util.UnitsConverter;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;

public class ElevationAxisNode
extends PComposite {
    private static final Color AXIS_COLOR = Color.BLACK;
    private static final Stroke AXIS_STROKE = new BasicStroke(1.0f);
    private static final Color TICK_COLOR = AXIS_COLOR;
    private static final Stroke TICK_STROKE = AXIS_STROKE;
    private static final Color TICK_LABEL_COLOR = TICK_COLOR;
    private static final Font TICK_LABEL_FONT = new PhetFont(12);
    private static final DecimalFormat TICK_LABEL_FORMAT = new DecimalFormat("0");
    private final PComposite _parentNode;
    private final GlaciersModelViewTransform _mvt;
    private final double _minElevation;
    private final double _maxElevation;
    private final boolean _tickLabelOnLeft;
    private boolean _englishUnits;
    private boolean _isDirty;

    public ElevationAxisNode(GlaciersModelViewTransform glaciersModelViewTransform, DoubleRange doubleRange, boolean bl, boolean bl2) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._mvt = glaciersModelViewTransform;
        this._minElevation = doubleRange.getMin();
        this._maxElevation = doubleRange.getMax();
        this._tickLabelOnLeft = bl;
        this._englishUnits = bl2;
        this._isDirty = true;
        this._parentNode = new PComposite();
        this.addChild(this._parentNode);
        this.update();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this._isDirty && this.getVisible()) {
            this.update();
        }
    }

    public void setEnglishUnits(boolean bl) {
        if (this._englishUnits != bl) {
            this._englishUnits = bl;
            this.update();
        }
    }

    private void update() {
        if (!this.getVisible()) {
            this._isDirty = true;
        } else {
            this._parentNode.removeAllChildren();
            PNode pNode = ElevationAxisNode.createAxis(0.0, this._minElevation, this._maxElevation, this._mvt);
            this._parentNode.addChild(pNode);
            double d = this._englishUnits ? UnitsConverter.metersToFeet(this._minElevation) : this._minElevation;
            double d2 = this._englishUnits ? UnitsConverter.metersToFeet(this._maxElevation) : this._maxElevation;
            int n = this._englishUnits ? 1000 : 250;
            String string = this._englishUnits ? GlaciersStrings.UNITS_FEET_SYMBOL : GlaciersStrings.UNITS_METERS;
            int n2 = (int)(d / (double)n) * n;
            while ((double)n2 <= d2) {
                PNode pNode2 = ElevationAxisNode.createTick(n2, string, this._tickLabelOnLeft);
                this._parentNode.addChild(pNode2);
                double d3 = this._englishUnits ? UnitsConverter.feetToMeters(n2) : (double)n2;
                Point2D.Double double_ = new Point2D.Double(0.0, d3);
                Point2D point2D = this._mvt.modelToView(double_);
                pNode2.setOffset(point2D);
                n2 += n;
            }
        }
    }

    private static PNode createAxis(double d, double d2, double d3, GlaciersModelViewTransform glaciersModelViewTransform) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        Point2D point2D = glaciersModelViewTransform.modelToView(double_);
        Point2D.Double double_2 = new Point2D.Double(d, d3);
        Point2D point2D2 = glaciersModelViewTransform.modelToView(double_2);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
        generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
        PPath pPath = new PPath(generalPath);
        pPath.setPaint(null);
        pPath.setStroke(AXIS_STROKE);
        pPath.setStrokePaint(AXIS_COLOR);
        return pPath;
    }

    private static PNode createTick(double d, String string, boolean bl) {
        PComposite pComposite = new PComposite();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        if (bl) {
            generalPath.lineTo(-10.0f, 0.0f);
        } else {
            generalPath.lineTo(10.0f, 0.0f);
        }
        PPath pPath = new PPath(generalPath);
        pPath.setPaint(null);
        pPath.setStroke(TICK_STROKE);
        pPath.setStrokePaint(TICK_COLOR);
        pComposite.addChild(pPath);
        String string2 = TICK_LABEL_FORMAT.format(d) + string;
        PText pText = new PText(string2);
        pText.setFont(TICK_LABEL_FONT);
        pText.setTextPaint(TICK_LABEL_COLOR);
        pComposite.addChild(pText);
        pPath.setOffset(0.0, 0.0);
        PBounds pBounds = pPath.getFullBoundsReference();
        PBounds pBounds2 = pText.getFullBoundsReference();
        if (bl) {
            pText.setOffset(pBounds.getMinX() - pBounds2.getWidth() - 2.0, pBounds.getCenterY() - pBounds2.getHeight() / 2.0);
        } else {
            pText.setOffset(pBounds.getMaxX() + 2.0, pBounds.getCenterY() - pBounds2.getHeight() / 2.0);
        }
        return pComposite;
    }
}

