/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view;

import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.glaciers.GlaciersStrings;
import edu.colorado.phet.glaciers.model.Climate;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Font;
import java.text.NumberFormat;

public class ELAValueNode
extends PText {
    private static final Font FONT = new PhetFont(14);
    private static final Color TEXT_COLOR = Color.WHITE;
    private static final NumberFormat NUMBER_FORMAT = new DefaultDecimalFormat("0");
    private final Climate _climate;
    private final Climate.ClimateListener _climateListener;

    public ELAValueNode(Climate climate) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.setFont(FONT);
        this.setTextPaint(TEXT_COLOR);
        this._climate = climate;
        this._climateListener = new Climate.ClimateListener(){

            public void snowfallChanged() {
                ELAValueNode.this.update();
            }

            public void temperatureChanged() {
                ELAValueNode.this.update();
            }
        };
        this._climate.addClimateListener(this._climateListener);
        this.update();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.update();
        }
    }

    private void update() {
        if (this.getVisible()) {
            double d = this._climate.getELA();
            String string = NUMBER_FORMAT.format(d);
            this.setText("ELA = " + string + " " + GlaciersStrings.UNITS_METERS);
        }
    }
}

