/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.glaciers.GlaciersStrings;
import edu.colorado.phet.glaciers.model.Valley;
import edu.colorado.phet.glaciers.util.UnitsConverter;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;

public class DistanceAxisNode
extends PComposite {
    private static final Color AXIS_COLOR = Color.BLACK;
    private static final Stroke AXIS_STROKE = new BasicStroke(1.0f);
    private static final Color TICK_COLOR = AXIS_COLOR;
    private static final Stroke TICK_STROKE = AXIS_STROKE;
    private static final Color TICK_LABEL_COLOR = TICK_COLOR;
    private static final Font TICK_LABEL_FONT = new PhetFont(12);
    private static final DecimalFormat TICK_LABEL_FORMAT = new DecimalFormat("0");
    private final PComposite _parentNode;
    private final Valley _valley;
    private final GlaciersModelViewTransform _mvt;
    private double _minX;
    private double _maxX;
    private boolean _isDirty;
    private boolean _englishUnits;

    public DistanceAxisNode(Valley valley, GlaciersModelViewTransform glaciersModelViewTransform, boolean bl) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._valley = valley;
        this._mvt = glaciersModelViewTransform;
        this._englishUnits = bl;
        this._parentNode = new PComposite();
        this.addChild(this._parentNode);
        this._maxX = 0.0;
        this._minX = 0.0;
        this._isDirty = true;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this._isDirty && this.getVisible()) {
            this.update();
        }
    }

    public void setRange(double d, double d2) {
        assert (d < d2);
        if (d != this._minX || d2 != this._maxX) {
            this._minX = d;
            this._maxX = d2;
            this.update();
        }
    }

    public void setEnglishUnits(boolean bl) {
        if (bl != this._englishUnits) {
            this._englishUnits = bl;
            this.update();
        }
    }

    private void update() {
        if (!this.getVisible()) {
            this._isDirty = true;
        } else {
            this._parentNode.removeAllChildren();
            PNode pNode = DistanceAxisNode.createAxis(this._valley, this._mvt, this._minX, this._maxX, 100.0);
            this._parentNode.addChild(pNode);
            double d = this._englishUnits ? UnitsConverter.metersToFeet(this._minX) : this._minX;
            double d2 = this._englishUnits ? UnitsConverter.metersToFeet(this._maxX) : this._maxX;
            int n = this._englishUnits ? 5000 : 1000;
            String string = this._englishUnits ? GlaciersStrings.UNITS_FEET_SYMBOL : GlaciersStrings.UNITS_METERS;
            int n2 = (int)(d / (double)n) * n;
            while ((double)n2 <= d2) {
                PNode pNode2 = DistanceAxisNode.createTick(n2, string);
                this._parentNode.addChild(pNode2);
                double d3 = this._englishUnits ? UnitsConverter.feetToMeters(n2) : (double)n2;
                double d4 = this._valley.getElevation(d3);
                Point2D.Double double_ = new Point2D.Double(d3, d4);
                Point2D point2D = this._mvt.modelToView(double_);
                pNode2.setOffset(point2D);
                n2 += n;
            }
            this._isDirty = false;
        }
    }

    private static PNode createAxis(Valley valley, GlaciersModelViewTransform glaciersModelViewTransform, double d, double d2, double d3) {
        GeneralPath generalPath = valley.createValleyFloorPath(glaciersModelViewTransform, d, d2, d3);
        PPath pPath = new PPath(generalPath);
        pPath.setPaint(null);
        pPath.setStroke(AXIS_STROKE);
        pPath.setStrokePaint(AXIS_COLOR);
        return pPath;
    }

    private static PNode createTick(int n, String string) {
        PComposite pComposite = new PComposite();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(0.0f, 10.0f);
        PPath pPath = new PPath(generalPath);
        pPath.setPaint(null);
        pPath.setStroke(TICK_STROKE);
        pPath.setStrokePaint(TICK_COLOR);
        pComposite.addChild(pPath);
        String string2 = TICK_LABEL_FORMAT.format(n) + string;
        PText pText = new PText(string2);
        pText.setFont(TICK_LABEL_FONT);
        pText.setTextPaint(TICK_LABEL_COLOR);
        pComposite.addChild(pText);
        pPath.setOffset(0.0, 0.0);
        PBounds pBounds = pPath.getFullBoundsReference();
        PBounds pBounds2 = pText.getFullBoundsReference();
        pText.setOffset(pBounds.getX() + pBounds.getWidth() / 2.0 - pBounds2.getWidth() / 2.0, pBounds.getMaxY() + 2.0);
        return pComposite;
    }
}

