/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.view;

import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.glaciers.model.Borehole;
import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class BoreholeNode
extends PComposite {
    private static final Stroke STROKE = new BasicStroke(1.0f);
    private static final Color STROKE_COLOR = Color.BLACK;
    private final Borehole _borehole;
    private final GlaciersModelViewTransform _mvt;
    private final Borehole.BoreholeListener _boreholeListener;
    private final GeneralPath _path;
    private final PPath _pathNode;
    private final Point2D _pView;

    public BoreholeNode(Borehole borehole, GlaciersModelViewTransform glaciersModelViewTransform) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._borehole = borehole;
        this._mvt = glaciersModelViewTransform;
        this._boreholeListener = new Borehole.BoreholeAdapter(){

            public void evolved() {
                BoreholeNode.this.update();
            }
        };
        this._borehole.addBoreholeListener(this._boreholeListener);
        this._path = new GeneralPath();
        this._pathNode = new PPath();
        this._pathNode.setStroke(STROKE);
        this._pathNode.setStrokePaint(STROKE_COLOR);
        this.addChild(this._pathNode);
        this._pView = new Point2D.Double();
        this.update();
    }

    public void cleanup() {
        this._borehole.removeBoreholeListener(this._boreholeListener);
    }

    private void update() {
        int n;
        this._path.reset();
        Point2D[] point2DArray = this._borehole.getPoints();
        if (point2DArray != null && point2DArray.length > 1) {
            for (n = 0; n < point2DArray.length; ++n) {
                this._mvt.modelToView(point2DArray[n], this._pView);
                if (n == 0) {
                    this._path.moveTo((float)this._pView.getX(), (float)this._pView.getY());
                    continue;
                }
                this._path.lineTo((float)this._pView.getX(), (float)this._pView.getY());
            }
        }
        this._pathNode.setPathTo(this._path);
        n = (int)(255.0 * (1.0 - this._borehole.getPercentFilledIn()));
        this._pathNode.setStrokePaint(ColorUtils.createColor(STROKE_COLOR, n));
    }
}

