/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.module.advanced;

import edu.colorado.phet.common.piccolophet.help.HelpBalloon;
import edu.colorado.phet.common.piccolophet.help.HelpPane;
import edu.colorado.phet.glaciers.GlaciersApplication;
import edu.colorado.phet.glaciers.GlaciersHelpBalloon;
import edu.colorado.phet.glaciers.GlaciersResources;
import edu.colorado.phet.glaciers.GlaciersStrings;
import edu.colorado.phet.glaciers.control.ClimateControlPanel;
import edu.colorado.phet.glaciers.control.GraphsControlPanel;
import edu.colorado.phet.glaciers.control.MiscControlPanel;
import edu.colorado.phet.glaciers.control.ViewControlPanel;
import edu.colorado.phet.glaciers.model.Climate;
import edu.colorado.phet.glaciers.model.Glacier;
import edu.colorado.phet.glaciers.model.GlaciersClock;
import edu.colorado.phet.glaciers.model.GlaciersModel;
import edu.colorado.phet.glaciers.module.GlaciersModule;
import edu.colorado.phet.glaciers.module.advanced.AdvancedControlPanel;
import edu.colorado.phet.glaciers.persistence.AdvancedConfig;
import edu.colorado.phet.glaciers.view.GlaciersPlayArea;
import java.awt.Frame;

public class AdvancedModule
extends GlaciersModule {
    private final GlaciersPlayArea _playArea;
    private final AdvancedControlPanel _controlPanel;

    public AdvancedModule(Frame frame) {
        super(GlaciersStrings.TITLE_ADVANCED);
        GlaciersModel glaciersModel = this.getGlaciersModel();
        this._playArea = new GlaciersPlayArea(glaciersModel);
        this.setSimulationPanel(this._playArea);
        int n = GlaciersResources.getInt("controlPanel.minHeight", 100);
        this._controlPanel = new AdvancedControlPanel(glaciersModel, this._playArea, frame, this, true, n);
        this.setClockControlPanel(this._controlPanel);
        if (this.hasHelp()) {
            HelpPane helpPane = this.getDefaultHelpPane();
            GlaciersHelpBalloon glaciersHelpBalloon = new GlaciersHelpBalloon(helpPane, GlaciersStrings.HELP_STEADY_STATE_BUTTON, HelpBalloon.BOTTOM_LEFT, 200.0);
            helpPane.add(glaciersHelpBalloon);
            glaciersHelpBalloon.pointAt(this._controlPanel.getMiscControlPanel().getSteadyStateButton());
            GlaciersHelpBalloon glaciersHelpBalloon2 = new GlaciersHelpBalloon(helpPane, GlaciersStrings.HELP_SIM_SPEED, HelpBalloon.BOTTOM_LEFT, 190.0);
            helpPane.add(glaciersHelpBalloon2);
            glaciersHelpBalloon2.pointAt(this._controlPanel.getClockControlPanel().getFrameRateControl());
            GlaciersHelpBalloon glaciersHelpBalloon3 = new GlaciersHelpBalloon(helpPane, GlaciersStrings.HELP_TOOLBOX, HelpBalloon.BOTTOM_CENTER, 30.0);
            helpPane.add(glaciersHelpBalloon3);
            glaciersHelpBalloon3.pointAt(this._playArea.getToolboxNode(), this._playArea.getZoomedCanvas());
        }
        this.reset();
    }

    public void activate() {
        super.activate();
        this._controlPanel.activate();
    }

    public void deactivate() {
        this._controlPanel.deactivate();
        super.deactivate();
    }

    public boolean hasHelp() {
        return false;
    }

    public void setHelpEnabled(boolean bl) {
        super.setHelpEnabled(bl);
        this._controlPanel.setHelpEnabled(bl);
        GlaciersApplication.getInstance().getPhetFrame().getHelpMenu().setHelpSelected(bl);
    }

    public void reset() {
        super.reset();
        GlaciersModel glaciersModel = this.getGlaciersModel();
        glaciersModel.reset();
        this.setClockRunningWhenActive(true);
        Glacier glacier = glaciersModel.getGlacier();
        Climate climate = glaciersModel.getClimate();
        ViewControlPanel viewControlPanel = this._controlPanel.getViewControlPanel();
        viewControlPanel.setEnglishUnitsSelected(true);
        viewControlPanel.setEquilibriumLineSelected(false);
        viewControlPanel.setIceFlowSelected(false);
        viewControlPanel.setSnowfallSelected(true);
        viewControlPanel.setCoordinatesSelected(false);
        ClimateControlPanel climateControlPanel = this._controlPanel.getClimateControlPanel();
        climateControlPanel.setSnowfall(climate.getSnowfall());
        climateControlPanel.setTemperature(climate.getTemperature());
        GraphsControlPanel graphsControlPanel = this._controlPanel.getGraphsControlPanel();
        graphsControlPanel.setGlacierLengthVerusTimeSelected(false);
        graphsControlPanel.setELAVersusTimeSelected(false);
        graphsControlPanel.setGlacialBudgetVersusElevationSelected(false);
        graphsControlPanel.setTemperatureVersusElevationSelected(false);
        MiscControlPanel miscControlPanel = this._controlPanel.getMiscControlPanel();
        miscControlPanel.setSteadyStateButtonEnabled(!glacier.isSteadyState());
        this._playArea.resetZoomedViewport();
        this._playArea.setEquilibriumLineVisible(viewControlPanel.isEquilibriumLineSelected());
        this._playArea.setIceFlowVisible(viewControlPanel.isIceFlowSelected());
        this._playArea.setAxesVisible(viewControlPanel.isCoordinatesSelected());
    }

    public AdvancedConfig save() {
        AdvancedConfig advancedConfig = new AdvancedConfig();
        advancedConfig.setActive(this.isActive());
        Object object = this.getGlaciersModel();
        Object object2 = ((GlaciersModel)object).getClock();
        advancedConfig.setClockFrameRate(((GlaciersClock)object2).getFrameRate());
        advancedConfig.setClockRunning(this.getClockRunningWhenActive());
        advancedConfig.setSnowfall(((GlaciersModel)object).getClimate().getSnowfall());
        advancedConfig.setTemperature(((GlaciersModel)object).getClimate().getTemperature());
        advancedConfig.setZoomedViewportPosition(this._playArea.getZoomedViewportPosition());
        object = this._controlPanel.getViewControlPanel();
        advancedConfig.setSnowfallSelected(((ViewControlPanel)object).isSnowfallSelected());
        advancedConfig.setEquilibriumLineSelected(((ViewControlPanel)object).isEquilibriumLineSelected());
        advancedConfig.setIceFlowVectorsSelected(((ViewControlPanel)object).isIceFlowSelected());
        advancedConfig.setIceFlowVectorsSelected(((ViewControlPanel)object).isCoordinatesSelected());
        object2 = this._controlPanel.getGraphsControlPanel();
        advancedConfig.setGlacierLengthVersusTimeChartSelected(((GraphsControlPanel)object2).isGlacierLengthVerusTimeSelected());
        advancedConfig.setELAVersusTimeChartSelected(((GraphsControlPanel)object2).isELAVersusTimeSelected());
        advancedConfig.setGlacialBudgetVersusElevationChartSelected(((GraphsControlPanel)object2).isGlacialBudgetVersusElevationSelected());
        advancedConfig.setTemperatureVerusElevationChartSelected(((GraphsControlPanel)object2).isTemperatureVersusElevationSelected());
        return advancedConfig;
    }

    public void load(AdvancedConfig advancedConfig) {
        if (advancedConfig.isActive()) {
            GlaciersApplication.getInstance().setActiveModule(this);
        }
        Object object = this.getGlaciersModel();
        Object object2 = ((GlaciersModel)object).getClock();
        ((GlaciersClock)object2).setFrameRate(advancedConfig.getClockFrameRate());
        this.setClockRunningWhenActive(advancedConfig.isClockRunning());
        ((GlaciersModel)object).getClimate().setSnowfall(advancedConfig.getSnowfall());
        ((GlaciersModel)object).getClimate().setTemperature(advancedConfig.getTemperature());
        ((GlaciersModel)object).getGlacier().setSteadyState();
        this._playArea.setZoomedViewportPosition(advancedConfig.getZoomedViewportPosition());
        object = this._controlPanel.getViewControlPanel();
        ((ViewControlPanel)object).setSnowfallSelected(advancedConfig.isSnowfallSelected());
        ((ViewControlPanel)object).setEquilibriumLineSelected(advancedConfig.isEquilibriumLineSelected());
        ((ViewControlPanel)object).setIceFlowSelected(advancedConfig.isIceFlowVectorsSelected());
        ((ViewControlPanel)object).setCoordinatesSelected(advancedConfig.isCoordinatesSelected());
        object2 = this._controlPanel.getGraphsControlPanel();
        ((GraphsControlPanel)object2).setGlacierLengthVerusTimeSelected(advancedConfig.isGlacierLengthVersusTimeChartSelected());
        ((GraphsControlPanel)object2).setELAVersusTimeSelected(advancedConfig.isELAVersusTimeChartSelected());
        ((GraphsControlPanel)object2).setGlacialBudgetVersusElevationSelected(advancedConfig.isGlacialBudgetVersusElevationChartSelected());
        ((GraphsControlPanel)object2).setTemperatureVersusElevationSelected(advancedConfig.isTemperatureVerusElevationChartSelected());
    }
}

