/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.model;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class Viewport {
    private final String _id;
    private Rectangle2D _bounds;
    private final ArrayList _listeners;

    public Viewport(String string) {
        this(string, new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0));
    }

    public Viewport(String string, Rectangle2D rectangle2D) {
        this._id = string;
        this._bounds = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        this._listeners = new ArrayList();
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        if (d != this._bounds.getX() || d2 != this._bounds.getY() || d3 != this._bounds.getWidth() || d4 != this._bounds.getHeight()) {
            this._bounds.setRect(d, d2, d3, d4);
            this.notifyBoundsChanged();
        }
    }

    public void setBounds(Rectangle2D rectangle2D) {
        this.setBounds(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(this._bounds.getX(), this._bounds.getY(), this._bounds.getWidth(), this._bounds.getHeight());
    }

    public Rectangle2D getBoundsReference() {
        return this._bounds;
    }

    public double getX() {
        return this._bounds.getX();
    }

    public double getY() {
        return this._bounds.getY();
    }

    public double getWidth() {
        return this._bounds.getWidth();
    }

    public void setPosition(Point2D point2D) {
        this.setPosition(point2D.getX(), point2D.getY());
    }

    public void setPosition(double d, double d2) {
        this.setBounds(d, d2, this._bounds.getWidth(), this._bounds.getHeight());
    }

    public Point2D getPosition() {
        return new Point2D.Double(this._bounds.getX(), this._bounds.getY());
    }

    public void translate(double d, double d2) {
        this.setPosition(this._bounds.getX() + d, this._bounds.getY() + d2);
    }

    public String toString() {
        return this.getClass().getName() + "[id=" + this._id + ",bounds=" + this._bounds.toString() + "]";
    }

    public void addViewportListener(ViewportListener viewportListener) {
        this._listeners.add(viewportListener);
    }

    private void notifyBoundsChanged() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((ViewportListener)iterator.next()).boundsChanged();
        }
    }

    public static interface ViewportListener {
        public void boundsChanged();
    }
}

