/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.model;

import edu.colorado.phet.glaciers.view.GlaciersModelViewTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class Valley {
    private static final Point2D[] NEGATIVE_X_SAMPLE_POINTS = new Point2D[]{new Point2D.Double(-52.0, 4561.0), new Point2D.Double(-642.0, 4676.0), new Point2D.Double(-1094.0, 4716.0), new Point2D.Double(-1884.0, 4886.0), new Point2D.Double(-2082.0, 4756.0), new Point2D.Double(-2787.0, 4576.0), new Point2D.Double(-3110.0, 4606.0), new Point2D.Double(-3255.0, 4566.0), new Point2D.Double(-3690.0, 4621.0), new Point2D.Double(-4476.0, 4346.0)};
    private final Point2D _headwallPosition = new Point2D.Double(0.0, this.getElevation(0.0));

    public Point2D getHeadwallPositionReference() {
        return this._headwallPosition;
    }

    public double getElevation(double d) {
        double d2 = 0.0;
        if (d >= 0.0) {
            d2 = 4000.0 - d / 30.0 + Math.exp(-(d - 5000.0) / 800.0);
            if (d2 < 0.0) {
                d2 = 0.0;
            }
        } else {
            d2 = this.getElevationToLeftOfHeadwall(d);
        }
        return d2;
    }

    public double getMaxElevation() {
        return this.getElevation(this._headwallPosition.getX());
    }

    public double getX(double d) {
        double d2 = 0.0;
        double d3 = 4000.0;
        boolean bl = false;
        while (!bl) {
            double d4 = this.getElevation(d2);
            if (Math.abs(d4 - d) < 1.0) {
                bl = true;
                continue;
            }
            if (d4 > d && d3 < 0.0 || d4 < d && d3 > 0.0) {
                d3 = -d3 / 2.0;
            }
            d2 += d3;
        }
        return d2;
    }

    public double getDirection(double d, double d2) {
        double d3 = this.getSlope(d, d2);
        return Math.atan(d3);
    }

    private double getSlope(double d, double d2) {
        if (d == d2) {
            throw new IllegalArgumentException("x1 and x2 must be different values");
        }
        double d3 = this.getElevation(d);
        double d4 = this.getElevation(d2);
        return (d3 - d4) / (d - d2);
    }

    public GeneralPath createValleyFloorPath(GlaciersModelViewTransform glaciersModelViewTransform, double d, double d2, double d3) {
        GeneralPath generalPath = new GeneralPath();
        double d4 = 0.0;
        Point2D.Double double_ = new Point2D.Double();
        Point2D point2D = new Point2D.Double();
        for (double d5 = d; d5 <= d2; d5 += d3) {
            d4 = this.getElevation(d5);
            ((Point2D)double_).setLocation(d5, d4);
            point2D = glaciersModelViewTransform.modelToView(double_, point2D);
            if (d5 == d) {
                generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
                continue;
            }
            generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
        }
        return generalPath;
    }

    private double getElevationToLeftOfHeadwall(double d) {
        assert (d < 0.0);
        double d2 = -1.0;
        Point2D point2D = NEGATIVE_X_SAMPLE_POINTS[NEGATIVE_X_SAMPLE_POINTS.length - 1];
        if (d < point2D.getX()) {
            d2 = point2D.getY();
        } else {
            Point2D point2D2 = null;
            Point2D point2D3 = null;
            for (int i = 0; i < NEGATIVE_X_SAMPLE_POINTS.length; ++i) {
                point2D2 = NEGATIVE_X_SAMPLE_POINTS[i];
                point2D3 = i == 0 ? new Point2D.Double(0.0, this.getElevation(0.0)) : NEGATIVE_X_SAMPLE_POINTS[i - 1];
                if (!(d >= point2D2.getX()) || !(d <= point2D3.getX())) continue;
                d2 = Valley.linearInterpolateElevation(d, point2D2, point2D3);
                break;
            }
            assert (d2 != -1.0);
        }
        return d2;
    }

    private static double linearInterpolateElevation(double d, Point2D point2D, Point2D point2D2) {
        double d2 = Math.abs((d - point2D.getX()) / (point2D.getX() - point2D2.getX()));
        double d3 = point2D.getY() + d2 * (point2D2.getY() - point2D.getY());
        return d3;
    }
}

