/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.model;

import edu.colorado.phet.glaciers.model.AbstractTool;
import edu.colorado.phet.glaciers.model.Climate;
import edu.colorado.phet.glaciers.model.Glacier;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;

public class GlacialBudgetMeter
extends AbstractTool {
    private final Glacier _glacier;
    private final Glacier.GlacierListener _glacierListener;
    private final Climate.ClimateListener _climateListener;
    private boolean _onSurface;
    private double _accumulation;
    private double _ablation;
    private double _glacialBudget;
    private final ArrayList _listeners;

    public GlacialBudgetMeter(Point2D point2D, Glacier glacier) {
        super(point2D);
        this._glacier = glacier;
        this._onSurface = false;
        this._climateListener = new Climate.ClimateListener(){

            public void temperatureChanged() {
                GlacialBudgetMeter.this.updateAllValues();
            }

            public void snowfallChanged() {
                GlacialBudgetMeter.this.updateAllValues();
            }
        };
        this._glacier.getClimate().addClimateListener(this._climateListener);
        this._glacierListener = new Glacier.GlacierAdapter(){

            public void iceThicknessChanged() {
                if (!GlacialBudgetMeter.this.isDragging() && GlacialBudgetMeter.this._onSurface) {
                    double d = GlacialBudgetMeter.this._glacier.getSurfaceElevation(GlacialBudgetMeter.this.getX());
                    GlacialBudgetMeter.this.setPosition(GlacialBudgetMeter.this.getX(), d);
                }
            }
        };
        this._glacier.addGlacierListener(this._glacierListener);
        this._accumulation = 0.0;
        this._ablation = 0.0;
        this._glacialBudget = 0.0;
        this._listeners = new ArrayList();
    }

    public void cleanup() {
        this._glacier.getClimate().removeClimateListener(this._climateListener);
        this._glacier.removeGlacierListener(this._glacierListener);
        super.cleanup();
    }

    public double getAccumulation() {
        return this._accumulation;
    }

    private void setAccumulation(double d) {
        if (d != this._accumulation) {
            this._accumulation = d;
            this.notifyAccumulationChanged();
        }
    }

    public double getAblation() {
        return this._ablation;
    }

    private void setAblation(double d) {
        if (d != this._ablation) {
            this._ablation = d;
            this.notifyAblationChanged();
        }
    }

    public double getGlacialBudget() {
        return this._glacialBudget;
    }

    private void setGlacialBudget(double d) {
        if (d != -d) {
            this._glacialBudget = d;
            this.notifyGlacialBudgetChanged();
        }
    }

    public void setPosition(double d, double d2) {
        double d3 = this._glacier.getSurfaceElevation(d);
        if (Math.abs(d2 - d3) < 150.0) {
            this._onSurface = true;
            super.setPosition(d, d3);
        } else {
            this._onSurface = false;
            super.setPosition(d, d2);
        }
    }

    protected void constrainDrop() {
        double d;
        double d2 = this.getX();
        double d3 = this._glacier.getSurfaceElevation(d2);
        if (d3 > (d = this._glacier.getValley().getElevation(d2))) {
            this.setPosition(d2, d3);
        } else {
            this.setPosition(d2, d);
        }
    }

    protected void handlePositionChanged() {
        this.updateAllValues();
    }

    private void updateAllValues() {
        Climate climate = this._glacier.getClimate();
        double d = this.getY();
        this.setAccumulation(climate.getAccumulation(d));
        this.setAblation(climate.getAblation(d));
        this.setGlacialBudget(climate.getGlacialBudget(d));
    }

    public void addGlacialBudgetMeterListener(GlacialBudgetMeterListener glacialBudgetMeterListener) {
        this._listeners.add(glacialBudgetMeterListener);
    }

    public void removeGlacialBudgetMeterListener(GlacialBudgetMeterListener glacialBudgetMeterListener) {
        this._listeners.remove(glacialBudgetMeterListener);
    }

    private void notifyAccumulationChanged() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((GlacialBudgetMeterListener)iterator.next()).accumulationChanged();
        }
    }

    private void notifyAblationChanged() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((GlacialBudgetMeterListener)iterator.next()).ablationChanged();
        }
    }

    private void notifyGlacialBudgetChanged() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((GlacialBudgetMeterListener)iterator.next()).glacialBudgetChanged();
        }
    }

    public static interface GlacialBudgetMeterListener {
        public void accumulationChanged();

        public void ablationChanged();

        public void glacialBudgetChanged();
    }
}

