/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.model;

import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.glaciers.model.Glacier;
import java.util.ArrayList;
import java.util.Iterator;

public class Debris
extends ClockAdapter {
    private Point3D _position;
    private Glacier _glacier;
    private Glacier.GlacierListener _glacierListener;
    private boolean _onValleyFloor;
    private ArrayList _listeners;
    private boolean _deletedSelf;

    public Debris(Point3D point3D, Glacier glacier) {
        assert (point3D.getX() >= glacier.getHeadwallX());
        assert (point3D.getY() < glacier.getSurfaceElevation(point3D.getX()));
        assert (point3D.getY() > glacier.getValley().getElevation(point3D.getX()));
        this._position = new Point3D.Double(point3D);
        this._glacier = glacier;
        this._onValleyFloor = false;
        this._glacierListener = new Glacier.GlacierAdapter(){

            public void iceThicknessChanged() {
                Debris.this.checkForDeletion();
            }
        };
        this._glacier.addGlacierListener(this._glacierListener);
        this._listeners = new ArrayList();
        this._deletedSelf = false;
    }

    public void cleanup() {
        this._glacier.removeGlacierListener(this._glacierListener);
    }

    public void deleteSelf() {
        if (!this._deletedSelf) {
            this._deletedSelf = true;
            this.notifyDeleteMe();
        }
    }

    public boolean isOnValleyFloor() {
        return this._onValleyFloor;
    }

    private void setOnValleyFloor(boolean bl) {
        if (bl != this._onValleyFloor) {
            this._onValleyFloor = bl;
            this.notifyOnValleyFloorChanged();
        }
    }

    private void setPosition(double d, double d2, double d3) {
        if (d != this.getX() || d2 != this.getY() || d3 != this.getZ()) {
            this._position.setLocation(d, d2, d3);
            this.notifyPositionChanged();
        }
    }

    public double getX() {
        return this._position.getX();
    }

    public double getY() {
        return this._position.getY();
    }

    public double getZ() {
        return this._position.getZ();
    }

    public String toString() {
        return this.getClass().getName() + "[position=" + this._position + ", onValleyFloor=" + this._onValleyFloor + ", deletedSelf=" + this._deletedSelf + "]";
    }

    private void checkForDeletion() {
        double d;
        if (this._onValleyFloor && !this._deletedSelf && (d = this._glacier.getIceThickness(this.getX())) > 0.0) {
            this.deleteSelf();
        }
    }

    public void clockTicked(ClockEvent clockEvent) {
        if (!this._onValleyFloor && !this._deletedSelf) {
            double d;
            double d2 = this.getY();
            if (d2 > (d = this._glacier.getSurfaceElevation(this.getX()))) {
                d2 = d;
            }
            Vector2D vector2D = this._glacier.getIceVelocity(this.getX(), d2);
            double d3 = clockEvent.getSimulationTimeChange();
            double d4 = this.getX() + vector2D.getX() * d3;
            double d5 = this.getY() + vector2D.getY() * d3;
            double d6 = this._glacier.getTerminusX();
            if (this.getX() < d6 && d4 > d6) {
                d4 = d6;
            }
            double d7 = this._glacier.getIceThickness(d4);
            double d8 = this._glacier.getValley().getElevation(d4);
            if (d5 > d8 + d7) {
                d5 = d8 + d7;
            } else if (d5 < d8) {
                d5 = d7 == 0.0 ? d8 : Math.min(d8 + 1.0, d8 + d7);
            }
            double d9 = this.getZ();
            if (d5 == this._glacier.getValley().getElevation(d4)) {
                this.setOnValleyFloor(true);
            }
            this.setPosition(d4, d5, d9);
        }
    }

    public void addDebrisListener(DebrisListener debrisListener) {
        this._listeners.add(debrisListener);
    }

    public void removeDebrisListener(DebrisListener debrisListener) {
        this._listeners.remove(debrisListener);
    }

    private void notifyPositionChanged() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((DebrisListener)iterator.next()).positionChanged();
        }
    }

    private void notifyOnValleyFloorChanged() {
        ArrayList arrayList = new ArrayList(this._listeners);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((DebrisListener)iterator.next()).onValleyFloorChanged(this);
        }
    }

    private void notifyDeleteMe() {
        ArrayList arrayList = new ArrayList(this._listeners);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((DebrisListener)iterator.next()).deleteMe(this);
        }
    }

    public static class DebrisAdapter
    implements DebrisListener {
        public void positionChanged() {
        }

        public void onValleyFloorChanged(Debris debris) {
        }

        public void deleteMe(Debris debris) {
        }
    }

    public static interface DebrisListener {
        public void positionChanged();

        public void onValleyFloorChanged(Debris var1);

        public void deleteMe(Debris var1);
    }
}

