/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.glaciers.model.Glacier;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;

public class Borehole
extends ClockAdapter {
    private final Glacier _glacier;
    private ArrayList _points;
    private double _percentFilledIn;
    private double _fillInStartTime;
    private double _fillInEndTime;
    private final ArrayList _listeners;

    public Borehole(Glacier glacier, Point2D point2D) {
        this._glacier = glacier;
        this._points = Borehole.createPoints(point2D, glacier);
        this._percentFilledIn = 0.0;
        this._fillInEndTime = -1.0;
        this._fillInStartTime = -1.0;
        this._listeners = new ArrayList();
    }

    public void cleanup() {
    }

    private static ArrayList createPoints(Point2D point2D, Glacier glacier) {
        ArrayList<Point2D.Double> arrayList = null;
        double d = point2D.getX();
        double d2 = glacier.getValley().getElevation(d);
        double d3 = glacier.getSurfaceElevation(d);
        double d4 = d3 - d2;
        if (d4 > 0.0) {
            arrayList = new ArrayList<Point2D.Double>();
            Point2D.Double double_ = null;
            double d5 = d2;
            while (d5 <= d3) {
                double_ = new Point2D.Double(d, d5);
                d5 = d5 != d3 && d5 + 10.0 > d3 ? d3 : (d5 += 10.0);
                arrayList.add(double_);
            }
        }
        return arrayList;
    }

    public Point2D[] getPoints() {
        return this._points.toArray(new Point2D[this._points.size()]);
    }

    public double getPercentFilledIn() {
        return this._percentFilledIn;
    }

    public void clockTicked(ClockEvent clockEvent) {
        if (this._points != null) {
            double d = clockEvent.getSimulationTime();
            if (this._fillInStartTime == -1.0) {
                this._fillInStartTime = d + 40.0;
                this._fillInEndTime = this._fillInStartTime + 40.0;
            }
            if (d >= this._fillInEndTime) {
                this.deleteMe();
            } else {
                Object object;
                this._percentFilledIn = d < this._fillInStartTime ? 0.0 : 1.0 - (this._fillInEndTime - d) / (this._fillInEndTime - this._fillInStartTime);
                double d2 = clockEvent.getSimulationTimeChange();
                double d3 = this._glacier.getTerminusX();
                ArrayList arrayList = new ArrayList(this._points);
                Point2D point2D2 = null;
                for (Point2D point2D2 : arrayList) {
                    double d4;
                    object = this._glacier.getIceVelocity(point2D2.getX(), point2D2.getY());
                    double d5 = point2D2.getX() + ((ImmutableVector2D)object).getX() * d2;
                    double d6 = point2D2.getY() + ((ImmutableVector2D)object).getY() * d2;
                    if (d5 > d3) {
                        d5 = d3;
                    }
                    if (d6 > (d4 = this._glacier.getSurfaceElevation(d5))) {
                        this._points.remove(point2D2);
                    }
                    point2D2.setLocation(d5, d6);
                }
                object = (Point2D)arrayList.get(0);
                if (this._points.size() < 2 || ((Point2D)object).getX() >= d3) {
                    this.deleteMe();
                } else {
                    this.notifyEvolved();
                }
            }
        }
    }

    private void deleteMe() {
        this._percentFilledIn = 1.0;
        this._points = null;
        this.notifyDeleteMe();
    }

    public void addBoreholeListener(BoreholeListener boreholeListener) {
        this._listeners.add(boreholeListener);
    }

    public void removeBoreholeListener(BoreholeListener boreholeListener) {
        this._listeners.remove(boreholeListener);
    }

    private void notifyEvolved() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((BoreholeListener)iterator.next()).evolved();
        }
    }

    private void notifyDeleteMe() {
        ArrayList arrayList = new ArrayList(this._listeners);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((BoreholeListener)iterator.next()).deleteMe(this);
        }
    }

    public static class BoreholeAdapter
    implements BoreholeListener {
        public void evolved() {
        }

        public void deleteMe(Borehole borehole) {
        }
    }

    public static interface BoreholeListener {
        public void evolved();

        public void deleteMe(Borehole var1);
    }
}

