/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.control;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.glaciers.GlaciersConstants;
import edu.colorado.phet.glaciers.GlaciersStrings;
import edu.colorado.phet.glaciers.control.AbstractSubPanel;
import edu.colorado.phet.glaciers.view.CoordinatesNode;
import edu.colorado.phet.glaciers.view.EquilibriumLineNode;
import edu.colorado.phet.glaciers.view.GlaciersPlayArea;
import edu.colorado.phet.glaciers.view.IceFlowNode;
import edu.colorado.phet.glaciers.view.SnowfallNode;
import edu.colorado.phet.glaciers.view.UnitsChangeListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ViewControlPanel
extends AbstractSubPanel {
    private static final Color BACKGROUND_COLOR = GlaciersConstants.SUBPANEL_BACKGROUND_COLOR;
    private static final String TITLE_STRING = GlaciersStrings.TITLE_VIEW_CONTROLS;
    private static final Color TITLE_COLOR = GlaciersConstants.SUBPANEL_TITLE_COLOR;
    private static final Font TITLE_FONT = GlaciersConstants.SUBPANEL_TITLE_FONT;
    private static final Color CONTROL_COLOR = GlaciersConstants.SUBPANEL_CONTROL_COLOR;
    private static final Font CONTROL_FONT = GlaciersConstants.SUBPANEL_CONTROL_FONT;
    private final GlaciersPlayArea _playArea;
    private final JRadioButton _englishUnitsButton;
    private final JRadioButton _metricUnitsButton;
    private final JCheckBox _equilibriumLineCheckBox;
    private final JCheckBox _iceFlowCheckBox;
    private final JCheckBox _coordinatesCheckBox;
    private final JCheckBox _snowfallCheckBox;
    private final JPanel _iceFlowPanel;
    private final JPanel _coordinatesPanel;
    private final ArrayList _unitsChangeListeners = new ArrayList();

    public ViewControlPanel(GlaciersPlayArea glaciersPlayArea) {
        super(TITLE_STRING, TITLE_COLOR, TITLE_FONT);
        this._playArea = glaciersPlayArea;
        JPanel jPanel = new JPanel();
        JComponent jComponent = new JLabel(GlaciersStrings.LABEL_UNITS);
        jComponent.setFont(CONTROL_FONT);
        jComponent.setForeground(CONTROL_COLOR);
        this._englishUnitsButton = new JRadioButton(GlaciersStrings.RADIO_BUTTON_ENGLISH_UNITS);
        this._englishUnitsButton.setFont(CONTROL_FONT);
        this._englishUnitsButton.setForeground(CONTROL_COLOR);
        this._englishUnitsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewControlPanel.this.handleUnitsButton();
            }
        });
        this._metricUnitsButton = new JRadioButton(GlaciersStrings.RADIO_BUTTON_METRIC_UNITS);
        this._metricUnitsButton.setFont(CONTROL_FONT);
        this._metricUnitsButton.setForeground(CONTROL_COLOR);
        this._metricUnitsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewControlPanel.this.handleUnitsButton();
            }
        });
        Serializable serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this._englishUnitsButton);
        ((ButtonGroup)serializable).add(this._metricUnitsButton);
        this._englishUnitsButton.setSelected(true);
        jPanel.add(jComponent);
        jPanel.add(this._englishUnitsButton);
        jPanel.add(this._metricUnitsButton);
        jComponent = new JPanel();
        this._equilibriumLineCheckBox = new JCheckBox(GlaciersStrings.CHECK_BOX_EQUILIBRIUM_LINE);
        this._equilibriumLineCheckBox.setFont(CONTROL_FONT);
        this._equilibriumLineCheckBox.setForeground(CONTROL_COLOR);
        this._equilibriumLineCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewControlPanel.this.handleEquilibriumLineCheckBox();
            }
        });
        serializable = new JLabel(EquilibriumLineNode.createIcon());
        jComponent.add(this._equilibriumLineCheckBox);
        jComponent.add((Component)serializable);
        this._iceFlowPanel = new JPanel();
        this._iceFlowCheckBox = new JCheckBox(GlaciersStrings.CHECK_BOX_ICE_FLOW);
        this._iceFlowCheckBox.setFont(CONTROL_FONT);
        this._iceFlowCheckBox.setForeground(CONTROL_COLOR);
        this._iceFlowCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewControlPanel.this.handleIceFlowCheckBox();
            }
        });
        serializable = new JLabel(IceFlowNode.createIcon());
        this._iceFlowPanel.add(this._iceFlowCheckBox);
        this._iceFlowPanel.add((Component)serializable);
        this._coordinatesPanel = new JPanel();
        this._coordinatesCheckBox = new JCheckBox(GlaciersStrings.CHECK_BOX_COORDINATES);
        this._coordinatesCheckBox.setFont(CONTROL_FONT);
        this._coordinatesCheckBox.setForeground(CONTROL_COLOR);
        this._coordinatesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewControlPanel.this.handleCoordinatesCheckBox();
            }
        });
        serializable = new JLabel(CoordinatesNode.createIcon());
        this._coordinatesPanel.add(this._coordinatesCheckBox);
        this._coordinatesPanel.add((Component)serializable);
        serializable = new JPanel();
        this._snowfallCheckBox = new JCheckBox(GlaciersStrings.CHECK_BOX_SNOWFALL);
        this._snowfallCheckBox.setFont(CONTROL_FONT);
        this._snowfallCheckBox.setForeground(CONTROL_COLOR);
        this._snowfallCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewControlPanel.this.handleSnowfallCheckBox();
            }
        });
        Serializable serializable2 = new JLabel(SnowfallNode.createIcon());
        ((Container)serializable).add(this._snowfallCheckBox);
        ((Container)serializable).add((Component)serializable2);
        serializable2 = new EasyGridBagLayout(this);
        this.setLayout((LayoutManager)((Object)serializable2));
        ((EasyGridBagLayout)serializable2).setInsets(new Insets(0, 0, 0, 0));
        ((EasyGridBagLayout)serializable2).setAnchor(17);
        ((EasyGridBagLayout)serializable2).addComponent(jPanel, 0, 0, 2, 1);
        ((EasyGridBagLayout)serializable2).addComponent(jComponent, 1, 0);
        ((EasyGridBagLayout)serializable2).addComponent((Component)serializable, 2, 0);
        ((EasyGridBagLayout)serializable2).addComponent(this._iceFlowPanel, 1, 1);
        ((EasyGridBagLayout)serializable2).addComponent(this._coordinatesPanel, 2, 1);
        SwingUtils.setBackgroundDeep(this, BACKGROUND_COLOR, null, false);
    }

    public void setEnglishUnitsSelected(boolean bl) {
        if (bl != this.isEnglishUnitsSelected()) {
            this._englishUnitsButton.setSelected(bl);
            this.handleUnitsButton();
        }
    }

    public boolean isEnglishUnitsSelected() {
        return this._englishUnitsButton.isSelected();
    }

    public void setEquilibriumLineSelected(boolean bl) {
        if (bl != this.isEquilibriumLineSelected()) {
            this._equilibriumLineCheckBox.setSelected(bl);
            this.handleEquilibriumLineCheckBox();
        }
    }

    public boolean isEquilibriumLineSelected() {
        return this._equilibriumLineCheckBox.isSelected();
    }

    public void setIceFlowSelected(boolean bl) {
        if (bl != this.isIceFlowSelected()) {
            this._iceFlowCheckBox.setSelected(bl);
            this.handleIceFlowCheckBox();
        }
    }

    public boolean isIceFlowSelected() {
        return this._iceFlowCheckBox.isSelected();
    }

    public void setCoordinatesSelected(boolean bl) {
        if (bl != this.isCoordinatesSelected()) {
            this._coordinatesCheckBox.setSelected(bl);
            this.handleCoordinatesCheckBox();
        }
    }

    public boolean isCoordinatesSelected() {
        return this._coordinatesCheckBox.isSelected();
    }

    public void setSnowfallSelected(boolean bl) {
        if (bl != this.isSnowfallSelected()) {
            this._snowfallCheckBox.setSelected(bl);
            this.handleSnowfallCheckBox();
        }
    }

    public boolean isSnowfallSelected() {
        return this._snowfallCheckBox.isSelected();
    }

    public void setCoordinatesCheckBoxVisible(boolean bl) {
        this._coordinatesPanel.setVisible(bl);
    }

    public void setIceFlowCheckBoxVisible(boolean bl) {
        this._iceFlowPanel.setVisible(bl);
    }

    public void addUnitsChangedListener(UnitsChangeListener unitsChangeListener) {
        this._unitsChangeListeners.add(unitsChangeListener);
    }

    private void notifyUnitsChanged() {
        boolean bl = this._englishUnitsButton.isSelected();
        Iterator iterator = this._unitsChangeListeners.iterator();
        while (iterator.hasNext()) {
            ((UnitsChangeListener)iterator.next()).unitsChanged(bl);
        }
    }

    private void handleUnitsButton() {
        this.notifyUnitsChanged();
    }

    private void handleEquilibriumLineCheckBox() {
        this._playArea.setEquilibriumLineVisible(this._equilibriumLineCheckBox.isSelected());
    }

    private void handleIceFlowCheckBox() {
        this._playArea.setIceFlowVisible(this._iceFlowCheckBox.isSelected());
    }

    private void handleCoordinatesCheckBox() {
        this._playArea.setAxesVisible(this._coordinatesCheckBox.isSelected());
    }

    private void handleSnowfallCheckBox() {
        this._playArea.setSnowfallVisible(this._snowfallCheckBox.isSelected());
    }
}

