/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.control;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.ButtonEventHandler;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.glaciers.model.Viewport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public abstract class ScrollArrowNode
extends PhetPNode {
    private static final Point2D TIP_POINT = new Point2D.Double(0.0, 0.0);
    private static final Point2D TAIL_POINT = new Point2D.Double(TIP_POINT.getX() - 35.0, TIP_POINT.getY());
    private static final Color FILL_COLOR = Color.WHITE;
    private static final Color STROKE_COLOR = Color.BLACK;
    private static final Stroke STROKE = new BasicStroke(1.5f);
    private final ArrayList _listeners;

    public ScrollArrowNode(double d) {
        this.rotate(d);
        ArrowNode arrowNode = new ArrowNode(TAIL_POINT, TIP_POINT, 25.0, 50.0, 25.0);
        arrowNode.setPaint(FILL_COLOR);
        arrowNode.setStroke(STROKE);
        arrowNode.setStrokePaint(STROKE_COLOR);
        this.addChild(arrowNode);
        this._listeners = new ArrayList();
        this.addInputEventListener(new CursorHandler());
        ButtonEventHandler buttonEventHandler = new ButtonEventHandler();
        this.addInputEventListener(buttonEventHandler);
        buttonEventHandler.addButtonEventListener(new ButtonEventHandler.ButtonEventAdapter(){
            private boolean _armed;

            public void setArmed(boolean bl) {
                if (bl != this._armed) {
                    this._armed = bl;
                    if (bl) {
                        ScrollArrowNode.this.setOffset(ScrollArrowNode.this.getXOffset() + 2.0, ScrollArrowNode.this.getYOffset() + 2.0);
                    } else {
                        ScrollArrowNode.this.setOffset(ScrollArrowNode.this.getXOffset() - 2.0, ScrollArrowNode.this.getYOffset() - 2.0);
                    }
                }
            }

            public void fire() {
                ActionEvent actionEvent = new ActionEvent(ScrollArrowNode.this, 0, "BUTTON_FIRED");
                for (int i = 0; i < ScrollArrowNode.this._listeners.size(); ++i) {
                    ((ActionListener)ScrollArrowNode.this._listeners.get(i)).actionPerformed(actionEvent);
                }
            }
        });
    }

    protected void addActionListener(ActionListener actionListener) {
        if (!this._listeners.contains(actionListener)) {
            this._listeners.add(actionListener);
        }
    }

    public static class LeftScrollArrowNode
    extends ScrollArrowNode {
        public LeftScrollArrowNode(final Viewport viewport, final Viewport viewport2) {
            super(Math.PI);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    double d = viewport2.getX() - viewport2.getWidth() / 2.0;
                    double d2 = Math.max(d, viewport.getX());
                    viewport2.setPosition(d2, viewport2.getY());
                }
            });
        }
    }

    public static class RightScrollArrowNode
    extends ScrollArrowNode {
        public RightScrollArrowNode(Viewport viewport, final Viewport viewport2, final double d) {
            super(0.0);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    double d3 = viewport2.getX() + viewport2.getWidth() / 2.0;
                    double d2 = Math.min(d3, d - viewport2.getWidth());
                    viewport2.setPosition(d2, viewport2.getY());
                }
            });
        }
    }
}

