/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.control;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.view.ResetAllButton;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.glaciers.GlaciersStrings;
import edu.colorado.phet.glaciers.control.HelpButton;
import edu.colorado.phet.glaciers.dialog.GlacierPictureDialog;
import edu.colorado.phet.glaciers.model.Glacier;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class MiscControlPanel
extends JPanel {
    private final Glacier _glacier;
    private final Frame _dialogOwner;
    private final JButton _pictureButton;
    private final JButton _steadyStateButton;
    private final ResetAllButton _resetAllButton;
    private final HelpButton _helpButton;
    private JDialog _glacierPictureDialog;
    private boolean _glacierPictureDialogWasOpen;
    private Point _glacierPictureDialogLocation;

    public MiscControlPanel(Glacier glacier, Frame frame, Module module) {
        this._dialogOwner = frame;
        this._glacier = glacier;
        glacier.addGlacierListener(new Glacier.GlacierAdapter(){

            public void steadyStateChanged() {
                MiscControlPanel.this.setSteadyStateButtonEnabled(!MiscControlPanel.this._glacier.isSteadyState());
            }
        });
        this._pictureButton = new JButton(GlaciersStrings.BUTTON_GLACIER_PICTURE);
        this._pictureButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MiscControlPanel.this.handlePictureButton();
            }
        });
        this._steadyStateButton = new JButton(GlaciersStrings.BUTTON_STEADY_STATE);
        this._steadyStateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MiscControlPanel.this._glacier.setSteadyState();
            }
        });
        this._resetAllButton = new ResetAllButton(module, (Component)this._dialogOwner);
        this._helpButton = new HelpButton(module);
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        int n = 0;
        easyGridBagLayout.addComponent(this._pictureButton, 0, n++);
        easyGridBagLayout.addComponent(this._steadyStateButton, 0, n++);
        easyGridBagLayout.addComponent(this._resetAllButton, 0, n++);
        if (module.hasHelp()) {
            easyGridBagLayout.addComponent(this._helpButton, 0, n++);
        }
    }

    public void setSteadyStateButtonEnabled(boolean bl) {
        this._steadyStateButton.setEnabled(bl);
    }

    public void setHelpEnabled(boolean bl) {
        this._helpButton.setHelpEnabled(bl);
    }

    public JComponent getSteadyStateButton() {
        return this._steadyStateButton;
    }

    public void activate() {
        if (this._glacierPictureDialogWasOpen) {
            this.handlePictureButton();
        }
    }

    public void deactivate() {
        boolean bl = this._glacierPictureDialogWasOpen = this._glacierPictureDialog != null;
        if (this._glacierPictureDialog != null) {
            this._glacierPictureDialog.dispose();
        }
    }

    private void handlePictureButton() {
        if (this._glacierPictureDialog == null) {
            this._glacierPictureDialog = new GlacierPictureDialog(this._dialogOwner);
            if (this._glacierPictureDialogLocation != null) {
                this._glacierPictureDialog.setLocation(this._glacierPictureDialogLocation);
            } else {
                SwingUtils.centerDialogInParent(this._glacierPictureDialog);
            }
            this._glacierPictureDialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    MiscControlPanel.this._glacierPictureDialogLocation = MiscControlPanel.this._glacierPictureDialog.getLocation();
                    MiscControlPanel.this._glacierPictureDialog.dispose();
                    MiscControlPanel.this._glacierPictureDialog = null;
                }
            });
            this._glacierPictureDialog.setVisible(true);
        }
    }
}

