/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.control;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.glaciers.GlaciersConstants;
import edu.colorado.phet.glaciers.GlaciersStrings;
import edu.colorado.phet.glaciers.charts.ELAVersusTimeChart;
import edu.colorado.phet.glaciers.charts.GlacialBudgetVersusElevationChart;
import edu.colorado.phet.glaciers.charts.GlacierLengthVersusTimeChart;
import edu.colorado.phet.glaciers.charts.TemperatureVersusElevationChart;
import edu.colorado.phet.glaciers.control.AbstractSubPanel;
import edu.colorado.phet.glaciers.model.GlaciersModel;
import edu.colorado.phet.glaciers.view.UnitsChangeListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;
import javax.swing.JDialog;

public class GraphsControlPanel
extends AbstractSubPanel
implements UnitsChangeListener {
    private static Dimension CHART_SIZE = new Dimension(900, 350);
    private static final Color BACKGROUND_COLOR = GlaciersConstants.SUBPANEL_BACKGROUND_COLOR;
    private static final String TITLE_STRING = GlaciersStrings.TITLE_GRAPH_CONTROLS;
    private static final Color TITLE_COLOR = GlaciersConstants.SUBPANEL_TITLE_COLOR;
    private static final Font TITLE_FONT = GlaciersConstants.SUBPANEL_TITLE_FONT;
    private static final Font CONTROL_FONT = GlaciersConstants.SUBPANEL_CONTROL_FONT;
    private static final Color CONTROL_COLOR = GlaciersConstants.SUBPANEL_CONTROL_COLOR;
    private final GlaciersModel _model;
    private final Frame _dialogOwner;
    private final JCheckBox _glacierLengthVersusTimeCheckBox;
    private final JCheckBox _elaVersusTimeCheckBox;
    private final JCheckBox _glacialBudgetVersusElevationCheckBox;
    private final JCheckBox _temperatureVersusElevationCheckBox;
    private GlacierLengthVersusTimeChart _glacierLengthVersusTimeChart;
    private ELAVersusTimeChart _elaVersusTimeChart;
    private JDialog _glacialBudgetVersusElevationChart;
    private JDialog _temperatureVersusElevationChart;
    private boolean _glacierLengthVersusTimeChartWasOpen;
    private boolean _elaVersusTimeChartWasOpen;
    private boolean _glacialBudgetVersusElevationChartWasOpen;
    private boolean _temperatureVersusElevationChartWasOpen;
    private Point _glacierLengthVersusTimeChartLocation;
    private Point _elaVersusTimeChartLocation;
    private Point _glacialBudgetVersusElevationChartLocation;
    private Point _temperatureVersusElevationChartLocation;
    private boolean _englishUnits;

    public GraphsControlPanel(GlaciersModel glaciersModel, Frame frame, boolean bl) {
        super(TITLE_STRING, TITLE_COLOR, TITLE_FONT);
        this._model = glaciersModel;
        this._dialogOwner = frame;
        this._englishUnits = bl;
        this._glacierLengthVersusTimeCheckBox = new JCheckBox(GlaciersStrings.TITLE_GLACIER_LENGTH_VERSUS_TIME);
        this._glacierLengthVersusTimeCheckBox.setFont(CONTROL_FONT);
        this._glacierLengthVersusTimeCheckBox.setForeground(CONTROL_COLOR);
        this._glacierLengthVersusTimeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphsControlPanel.this.handleGlacierLengthVersusTimeCheckBox();
            }
        });
        this._elaVersusTimeCheckBox = new JCheckBox(GlaciersStrings.TITLE_ELA_VERSUS_TIME);
        this._elaVersusTimeCheckBox.setFont(CONTROL_FONT);
        this._elaVersusTimeCheckBox.setForeground(CONTROL_COLOR);
        this._elaVersusTimeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphsControlPanel.this.handleELAVersusTimeCheckBox();
            }
        });
        this._glacialBudgetVersusElevationCheckBox = new JCheckBox(GlaciersStrings.TITLE_GLACIAL_BUDGET_VERSUS_ELEVATION);
        this._glacialBudgetVersusElevationCheckBox.setFont(CONTROL_FONT);
        this._glacialBudgetVersusElevationCheckBox.setForeground(CONTROL_COLOR);
        this._glacialBudgetVersusElevationCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphsControlPanel.this.handleGlacialBudgetVersusElevationCheckBox();
            }
        });
        this._temperatureVersusElevationCheckBox = new JCheckBox(GlaciersStrings.TITLE_TEMPERATURE_VERSUS_ELEVATION);
        this._temperatureVersusElevationCheckBox.setFont(CONTROL_FONT);
        this._temperatureVersusElevationCheckBox.setForeground(CONTROL_COLOR);
        this._temperatureVersusElevationCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphsControlPanel.this.handleTemperatureVersusElevationCheckBox();
            }
        });
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(this._glacierLengthVersusTimeCheckBox, n++, n2);
        easyGridBagLayout.addComponent(this._elaVersusTimeCheckBox, n++, n2);
        easyGridBagLayout.addComponent(this._glacialBudgetVersusElevationCheckBox, n++, n2);
        easyGridBagLayout.addComponent(this._temperatureVersusElevationCheckBox, n++, n2);
        SwingUtils.setBackgroundDeep(this, BACKGROUND_COLOR, null, false);
    }

    public void setGlacierLengthVerusTimeSelected(boolean bl) {
        if (bl != this.isGlacierLengthVerusTimeSelected()) {
            this._glacierLengthVersusTimeCheckBox.setSelected(bl);
            this.handleGlacierLengthVersusTimeCheckBox();
        }
    }

    public boolean isGlacierLengthVerusTimeSelected() {
        return this._glacierLengthVersusTimeCheckBox.isSelected();
    }

    public void setELAVersusTimeSelected(boolean bl) {
        if (bl != this.isELAVersusTimeSelected()) {
            this._elaVersusTimeCheckBox.setSelected(bl);
            this.handleELAVersusTimeCheckBox();
        }
    }

    public boolean isELAVersusTimeSelected() {
        return this._elaVersusTimeCheckBox.isSelected();
    }

    public void setGlacialBudgetVersusElevationSelected(boolean bl) {
        if (bl != this.isGlacialBudgetVersusElevationSelected()) {
            this._glacialBudgetVersusElevationCheckBox.setSelected(bl);
            this.handleGlacialBudgetVersusElevationCheckBox();
        }
    }

    public boolean isGlacialBudgetVersusElevationSelected() {
        return this._glacialBudgetVersusElevationCheckBox.isSelected();
    }

    public void setTemperatureVersusElevationSelected(boolean bl) {
        if (bl != this.isTemperatureVersusElevationSelected()) {
            this._temperatureVersusElevationCheckBox.setSelected(bl);
            this.handleTemperatureVersusElevationCheckBox();
        }
    }

    public boolean isTemperatureVersusElevationSelected() {
        return this._temperatureVersusElevationCheckBox.isSelected();
    }

    public void activate() {
        this.setGlacierLengthVerusTimeSelected(this._glacierLengthVersusTimeChartWasOpen);
        this.setELAVersusTimeSelected(this._elaVersusTimeChartWasOpen);
        this.setGlacialBudgetVersusElevationSelected(this._glacialBudgetVersusElevationChartWasOpen);
        this.setTemperatureVersusElevationSelected(this._temperatureVersusElevationChartWasOpen);
    }

    public void deactivate() {
        this._glacierLengthVersusTimeChartWasOpen = this.isGlacierLengthVerusTimeSelected();
        this._elaVersusTimeChartWasOpen = this.isELAVersusTimeSelected();
        this._glacialBudgetVersusElevationChartWasOpen = this.isGlacialBudgetVersusElevationSelected();
        this._temperatureVersusElevationChartWasOpen = this.isTemperatureVersusElevationSelected();
        this.setGlacierLengthVerusTimeSelected(false);
        this.setELAVersusTimeSelected(false);
        this.setGlacialBudgetVersusElevationSelected(false);
        this.setTemperatureVersusElevationSelected(false);
    }

    private void handleGlacierLengthVersusTimeCheckBox() {
        if (this._glacierLengthVersusTimeCheckBox.isSelected()) {
            this.openGlacierLengthVersusTimeChart();
        } else {
            this.closeGlacierLengthVersusTimeChart();
        }
    }

    private void openGlacierLengthVersusTimeChart() {
        this._glacierLengthVersusTimeChart = new GlacierLengthVersusTimeChart(this._dialogOwner, CHART_SIZE, this._model.getGlacier(), this._model.getClock(), this._englishUnits);
        GraphsControlPanel.setDialogLocation(this._glacierLengthVersusTimeChart, this._glacierLengthVersusTimeChartLocation);
        this._glacierLengthVersusTimeChart.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GraphsControlPanel.this.setGlacierLengthVerusTimeSelected(false);
            }
        });
        this._glacierLengthVersusTimeChart.setVisible(true);
    }

    private void closeGlacierLengthVersusTimeChart() {
        if (this._glacierLengthVersusTimeChart != null) {
            this._glacierLengthVersusTimeChartLocation = this._glacierLengthVersusTimeChart.getLocation();
            this._glacierLengthVersusTimeChart.dispose();
            this._glacierLengthVersusTimeChart = null;
        }
    }

    private void handleELAVersusTimeCheckBox() {
        if (this._elaVersusTimeCheckBox.isSelected()) {
            this.openELAVersusTimeChart();
        } else {
            this.closeELAVersusTimeChart();
        }
    }

    private void openELAVersusTimeChart() {
        this._elaVersusTimeChart = new ELAVersusTimeChart(this._dialogOwner, CHART_SIZE, this._model.getClimate(), this._model.getClock(), this._englishUnits);
        GraphsControlPanel.setDialogLocation(this._elaVersusTimeChart, this._elaVersusTimeChartLocation);
        this._elaVersusTimeChart.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GraphsControlPanel.this.setELAVersusTimeSelected(false);
            }
        });
        this._elaVersusTimeChart.setVisible(true);
    }

    private void closeELAVersusTimeChart() {
        if (this._elaVersusTimeChart != null) {
            this._elaVersusTimeChartLocation = this._elaVersusTimeChart.getLocation();
            this._elaVersusTimeChart.dispose();
            this._elaVersusTimeChart = null;
        }
    }

    private void handleGlacialBudgetVersusElevationCheckBox() {
        if (this._glacialBudgetVersusElevationCheckBox.isSelected()) {
            this.openGlacialBudgetVersusElevationChart();
        } else {
            this.closeGlacialBudgetVersusElevationChart();
        }
    }

    private void openGlacialBudgetVersusElevationChart() {
        this._glacialBudgetVersusElevationChart = new GlacialBudgetVersusElevationChart(this._dialogOwner, CHART_SIZE, this._model.getClimate(), this._englishUnits);
        GraphsControlPanel.setDialogLocation(this._glacialBudgetVersusElevationChart, this._glacialBudgetVersusElevationChartLocation);
        this._glacialBudgetVersusElevationChart.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GraphsControlPanel.this.setGlacialBudgetVersusElevationSelected(false);
            }
        });
        this._glacialBudgetVersusElevationChart.setVisible(true);
    }

    private void closeGlacialBudgetVersusElevationChart() {
        if (this._glacialBudgetVersusElevationChart != null) {
            this._glacialBudgetVersusElevationChartLocation = this._glacialBudgetVersusElevationChart.getLocation();
            this._glacialBudgetVersusElevationChart.dispose();
            this._glacialBudgetVersusElevationChart = null;
        }
    }

    private void handleTemperatureVersusElevationCheckBox() {
        if (this._temperatureVersusElevationCheckBox.isSelected()) {
            this.openTemperatureVersusElevationChart();
        } else {
            this.closeTemperatureVersusElevationChart();
        }
    }

    private void openTemperatureVersusElevationChart() {
        this._temperatureVersusElevationChart = new TemperatureVersusElevationChart(this._dialogOwner, CHART_SIZE, this._model.getClimate(), this._englishUnits);
        GraphsControlPanel.setDialogLocation(this._temperatureVersusElevationChart, this._temperatureVersusElevationChartLocation);
        this._temperatureVersusElevationChart.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GraphsControlPanel.this.setTemperatureVersusElevationSelected(false);
            }
        });
        this._temperatureVersusElevationChart.setVisible(true);
    }

    private void closeTemperatureVersusElevationChart() {
        if (this._temperatureVersusElevationChart != null) {
            this._temperatureVersusElevationChartLocation = this._temperatureVersusElevationChart.getLocation();
            this._temperatureVersusElevationChart.dispose();
            this._temperatureVersusElevationChart = null;
        }
    }

    private static void setDialogLocation(JDialog jDialog, Point point) {
        if (point != null) {
            jDialog.setLocation(point);
        } else {
            SwingUtils.centerDialogInParent(jDialog);
        }
    }

    public void unitsChanged(boolean bl) {
        if (bl != this._englishUnits) {
            this._englishUnits = bl;
            if (this._glacierLengthVersusTimeChart != null) {
                this._glacierLengthVersusTimeChart.setEnglishUnits(bl);
            }
            if (this._elaVersusTimeChart != null) {
                this._elaVersusTimeChart.setEnglishUnits(bl);
            }
            if (this._glacialBudgetVersusElevationChart != null) {
                this.closeGlacialBudgetVersusElevationChart();
                this.openGlacialBudgetVersusElevationChart();
            }
            if (this._temperatureVersusElevationChart != null) {
                this.closeTemperatureVersusElevationChart();
                this.openTemperatureVersusElevationChart();
            }
        }
    }
}

