/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.control;

import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloClockControlPanel;
import edu.colorado.phet.glaciers.GlaciersConstants;
import edu.colorado.phet.glaciers.GlaciersStrings;
import edu.colorado.phet.glaciers.control.SliderOnlyLayoutStrategy;
import edu.colorado.phet.glaciers.model.GlaciersClock;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GlaciersClockControlPanel
extends PiccoloClockControlPanel {
    private final GlaciersClock _clock;
    private final ConstantDtClock.ConstantDtClockListener _clockListener;
    private final LinearValueControl _frameRateControl;

    public GlaciersClockControlPanel(GlaciersClock glaciersClock) {
        super(glaciersClock);
        this._clock = glaciersClock;
        this._clockListener = new ConstantDtClock.ConstantDtClockAdapter(){

            public void delayChanged(ConstantDtClock.ConstantDtClockEvent constantDtClockEvent) {
                GlaciersClockControlPanel.this._frameRateControl.setValue(GlaciersClockControlPanel.this._clock.getFrameRate());
            }
        };
        this._clock.addConstantDtClockListener(this._clockListener);
        this.setRewindButtonVisible(false);
        this.setTimeDisplayVisible(true);
        this.setUnits(GlaciersStrings.UNITS_YEARS);
        this.setTimeFormat(GlaciersConstants.CLOCK_DISPLAY_FORMAT);
        this.setTimeColumns(10);
        double d = GlaciersConstants.CLOCK_FRAME_RATE_RANGE.getMin();
        double d2 = GlaciersConstants.CLOCK_FRAME_RATE_RANGE.getMax();
        String string = "";
        String string2 = "";
        String string3 = "";
        this._frameRateControl = new LinearValueControl(d, d2, string, string2, string3, new SliderOnlyLayoutStrategy());
        this._frameRateControl.setValue(this._clock.getFrameRate());
        this._frameRateControl.setMinorTicksVisible(false);
        Hashtable<Double, JLabel> hashtable = new Hashtable<Double, JLabel>();
        hashtable.put(new Double(d), new JLabel(GlaciersStrings.SLIDER_CLOCK_SLOW));
        hashtable.put(new Double(d2), new JLabel(GlaciersStrings.SLIDER_CLOCK_FAST));
        this._frameRateControl.setTickLabels(hashtable);
        Dictionary dictionary = this._frameRateControl.getSlider().getLabelTable();
        Enumeration enumeration = dictionary.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof JComponent)) continue;
            ((JComponent)v).setFont(new PhetFont(10));
        }
        this._frameRateControl.setSliderWidth(125);
        this.addBetweenTimeDisplayAndButtons(this._frameRateControl);
        this._frameRateControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                GlaciersClockControlPanel.this._clock.setFrameRate((int)GlaciersClockControlPanel.this._frameRateControl.getValue());
            }
        });
    }

    public JComponent getFrameRateControl() {
        return this._frameRateControl;
    }
}

