/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers.control;

import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.HorizontalLayoutStrategy;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.ILayoutStrategy;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.glaciers.GlaciersConstants;
import edu.colorado.phet.glaciers.GlaciersStrings;
import edu.colorado.phet.glaciers.control.AbstractSubPanel;
import edu.colorado.phet.glaciers.model.Climate;
import edu.colorado.phet.glaciers.util.UnitsConverter;
import edu.colorado.phet.glaciers.view.UnitsChangeListener;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ClimateControlPanel
extends AbstractSubPanel
implements UnitsChangeListener {
    private static final Color BACKGROUND_COLOR = GlaciersConstants.SUBPANEL_BACKGROUND_COLOR;
    private static final String TITLE_STRING = GlaciersStrings.TITLE_CLIMATE_CONTROLS;
    private static final Color TITLE_COLOR = GlaciersConstants.SUBPANEL_TITLE_COLOR;
    private static final Font TITLE_FONT = GlaciersConstants.SUBPANEL_TITLE_FONT;
    private static final Color CONTROL_COLOR = GlaciersConstants.SUBPANEL_CONTROL_COLOR;
    private static final Font CONTROL_FONT = GlaciersConstants.SUBPANEL_CONTROL_FONT;
    private static final DoubleRange METRIC_TEMPERATURE_RANGE = GlaciersConstants.TEMPERATURE_RANGE;
    private static final DoubleRange ENGLISH_TEMPERATURE_RANGE = new DoubleRange(UnitsConverter.celsiusToFahrenheit(METRIC_TEMPERATURE_RANGE.getMin()), UnitsConverter.celsiusToFahrenheit(METRIC_TEMPERATURE_RANGE.getMax()));
    private static final DoubleRange METRIC_SNOWFALL_RANGE = GlaciersConstants.SNOWFALL_RANGE;
    private static final DoubleRange ENGLISH_SNOWFALL_RANGE = new DoubleRange(UnitsConverter.metersToFeet(METRIC_SNOWFALL_RANGE.getMin()), UnitsConverter.metersToFeet(METRIC_SNOWFALL_RANGE.getMax()));
    private final AbstractClimateControls _englishClimateControls;
    private final AbstractClimateControls _metricClimateControls;
    private final CardLayout _cardLayout;

    public ClimateControlPanel(Climate climate, boolean bl) {
        super(TITLE_STRING, TITLE_COLOR, TITLE_FONT);
        this._englishClimateControls = new EnglishClimateControls(climate);
        this._metricClimateControls = new MetricClimateControls(climate);
        this._cardLayout = new CardLayout();
        this.setLayout(this._cardLayout);
        this.add((Component)this._englishClimateControls, "english");
        this.add((Component)this._metricClimateControls, "metric");
        Class[] classArray = new Class[]{JTextField.class};
        SwingUtils.setBackgroundDeep(this, BACKGROUND_COLOR, classArray, false);
        this.unitsChanged(bl);
    }

    public void setSnowfall(double d) {
        this._englishClimateControls.setSnowfall(UnitsConverter.metersToFeet(d));
        this._metricClimateControls.setSnowfall(d);
    }

    public void setTemperature(double d) {
        this._englishClimateControls.setTemperature(UnitsConverter.celsiusToFahrenheit(d));
        this._metricClimateControls.setTemperature(d);
    }

    public void unitsChanged(boolean bl) {
        if (bl) {
            this._cardLayout.show(this, "english");
        } else {
            this._cardLayout.show(this, "metric");
        }
    }

    private static abstract class AbstractClimateControls
    extends JPanel {
        private final LinearValueControl _temperatureControl;
        private final LinearValueControl _snowfallControl;
        private final ArrayList _listeners = new ArrayList();

        public AbstractClimateControls(DoubleRange doubleRange, String string, DoubleRange doubleRange2, String string2) {
            Object object;
            JLabel jLabel = new JLabel(GlaciersStrings.SLIDER_TEMPERATURE);
            double d = doubleRange.getMin();
            double d2 = doubleRange.getMax();
            String string3 = "";
            Object object2 = new HorizontalLayoutStrategy();
            this._temperatureControl = new LinearValueControl(d, d2, string3, "#0.0", string, (ILayoutStrategy)object2);
            this._temperatureControl.setUpDownArrowDelta(0.01);
            this._temperatureControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    AbstractClimateControls.this.notifyTemperatureChanged();
                }
            });
            jLabel.setForeground(CONTROL_COLOR);
            jLabel.setFont(CONTROL_FONT);
            this._temperatureControl.setFont(CONTROL_FONT);
            this._temperatureControl.getUnitsLabel().setForeground(CONTROL_COLOR);
            Object object3 = this._temperatureControl.getSlider().getLabelTable();
            Object object4 = ((Dictionary)object3).elements();
            while (object4.hasMoreElements()) {
                object = object4.nextElement();
                if (object instanceof JComponent) {
                    ((JComponent)object).setForeground(CONTROL_COLOR);
                }
                ((JComponent)object).setFont(CONTROL_FONT);
            }
            JLabel jLabel2 = new JLabel(GlaciersStrings.SLIDER_SNOWFALL);
            double d3 = doubleRange2.getMin();
            double d4 = doubleRange2.getMax();
            object2 = "";
            object3 = new HorizontalLayoutStrategy();
            this._snowfallControl = new LinearValueControl(d3, d4, (String)object2, "#0.0", string2, (ILayoutStrategy)object3);
            this._snowfallControl.setUpDownArrowDelta(0.01);
            this._snowfallControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    AbstractClimateControls.this.notifySnowfallChanged();
                }
            });
            jLabel2.setForeground(CONTROL_COLOR);
            jLabel2.setFont(CONTROL_FONT);
            this._snowfallControl.setFont(CONTROL_FONT);
            this._snowfallControl.getUnitsLabel().setForeground(CONTROL_COLOR);
            object4 = this._snowfallControl.getSlider().getLabelTable();
            object = ((Dictionary)object4).elements();
            while (object.hasMoreElements()) {
                Object e = object.nextElement();
                if (e instanceof JComponent) {
                    ((JComponent)e).setForeground(CONTROL_COLOR);
                }
                ((JComponent)e).setFont(CONTROL_FONT);
            }
            EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
            easyGridBagLayout.setInsets(new Insets(0, 2, 0, 2));
            this.setLayout(easyGridBagLayout);
            int n = 0;
            int n2 = 0;
            easyGridBagLayout.addAnchoredComponent(jLabel, n, n2++, 13);
            easyGridBagLayout.addAnchoredComponent(this._temperatureControl, n++, n2, 17);
            n2 = 0;
            easyGridBagLayout.addAnchoredComponent(jLabel2, n, n2++, 13);
            easyGridBagLayout.addAnchoredComponent(this._snowfallControl, n++, n2, 17);
        }

        public void setSnowfall(double d) {
            if (d != this.getSnowfall()) {
                this._snowfallControl.setValue(d);
            }
        }

        public double getSnowfall() {
            return this._snowfallControl.getValue();
        }

        public void setTemperature(double d) {
            if (d != this._temperatureControl.getValue()) {
                this._temperatureControl.setValue(d);
            }
        }

        public double getTemperature() {
            return this._temperatureControl.getValue();
        }

        public void addClimateControlsChangeListener(ClimateControlsChangeListener climateControlsChangeListener) {
            this._listeners.add(climateControlsChangeListener);
        }

        private void notifyTemperatureChanged() {
            Iterator iterator = this._listeners.iterator();
            while (iterator.hasNext()) {
                ((ClimateControlsChangeListener)iterator.next()).temperatureChanged(this.getTemperature());
            }
        }

        private void notifySnowfallChanged() {
            Iterator iterator = this._listeners.iterator();
            while (iterator.hasNext()) {
                ((ClimateControlsChangeListener)iterator.next()).snowfallChanged(this.getSnowfall());
            }
        }

        public static interface ClimateControlsChangeListener {
            public void temperatureChanged(double var1);

            public void snowfallChanged(double var1);
        }
    }

    private static class EnglishClimateControls
    extends AbstractClimateControls {
        public EnglishClimateControls(final Climate climate) {
            super(ENGLISH_TEMPERATURE_RANGE, GlaciersStrings.UNITS_FAHRENHEIT, ENGLISH_SNOWFALL_RANGE, GlaciersStrings.UNITS_FEET);
            climate.addClimateListener(new Climate.ClimateListener(){

                public void snowfallChanged() {
                    EnglishClimateControls.this.setSnowfall(UnitsConverter.metersToFeet(climate.getSnowfall()));
                }

                public void temperatureChanged() {
                    EnglishClimateControls.this.setTemperature(UnitsConverter.celsiusToFahrenheit(climate.getTemperature()));
                }
            });
            this.addClimateControlsChangeListener(new AbstractClimateControls.ClimateControlsChangeListener(){

                public void temperatureChanged(double d) {
                    climate.setTemperature(UnitsConverter.fahrenheitToCelsius(EnglishClimateControls.this.getTemperature()));
                }

                public void snowfallChanged(double d) {
                    climate.setSnowfall(UnitsConverter.feetToMeters(EnglishClimateControls.this.getSnowfall()));
                }
            });
        }
    }

    private static class MetricClimateControls
    extends AbstractClimateControls {
        public MetricClimateControls(final Climate climate) {
            super(METRIC_TEMPERATURE_RANGE, GlaciersStrings.UNITS_CELSIUS, METRIC_SNOWFALL_RANGE, GlaciersStrings.UNITS_METERS);
            climate.addClimateListener(new Climate.ClimateListener(){

                public void snowfallChanged() {
                    MetricClimateControls.this.setSnowfall(climate.getSnowfall());
                }

                public void temperatureChanged() {
                    MetricClimateControls.this.setTemperature(climate.getTemperature());
                }
            });
            this.addClimateControlsChangeListener(new AbstractClimateControls.ClimateControlsChangeListener(){

                public void temperatureChanged(double d) {
                    climate.setTemperature(MetricClimateControls.this.getTemperature());
                }

                public void snowfallChanged(double d) {
                    climate.setSnowfall(MetricClimateControls.this.getSnowfall());
                }
            });
        }
    }
}

