/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.glaciers;

import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;

public class GlaciersConstants {
    public static final double[] DEBUG_BACKGROUND_IMAGE_ALIGNMENT_X_VALUES = new double[]{0.0, 10000.0, 70000.0};
    public static final IntegerRange CLOCK_FRAME_RATE_RANGE = new IntegerRange(1, 24, 4);
    public static final DecimalFormat CLOCK_DISPLAY_FORMAT = new DecimalFormat("0");
    public static final DoubleRange TEMPERATURE_RANGE = new DoubleRange(13.0, 20.0, 19.0);
    public static final DoubleRange SNOWFALL_RANGE = new DoubleRange(0.0, 1.5, 0.93);
    public static final Point2D BIRDS_EYE_VIEWPORT_OFFSET = new Point2D.Double(-4400.0, 1000.0);
    public static final double YAW_ROTATION = Math.toRadians(30.0);
    public static final Color BIRDS_EYE_CANVAS_COLOR;
    public static final Color ZOOMED_CANVAS_COLOR;
    public static final Color ICE_SURFACE_ABOVE_ELA_COLOR;
    public static final Color ICE_SURFACE_BELOW_ELA_COLOR;
    public static final Color ICE_CROSS_SECTION_COLOR;
    public static final Color SNOW_PATCH_SURFACE_COLOR;
    public static final Color SNOW_PATCH_CROSS_SECTION_COLOR;
    public static final Color RIPPLE_ABOVE_ELA_COLOR;
    public static final Color RIPPLE_BELOW_ELA_COLOR;
    public static final Color DEBRIS_COLOR;
    public static final Color UNDERGROUND_COLOR;
    public static final Color CONTROL_PANEL_BACKGROUND_COLOR;
    public static final Color GLACIAL_BUDGET_COLOR;
    public static final Color ACCUMULATION_COLOR;
    public static final Color ABLATION_COLOR;
    public static final Color NEGATIVE_ABLATION_COLOR;
    public static final Font SUBPANEL_TITLE_FONT;
    public static final Font SUBPANEL_CONTROL_FONT;
    public static final Color SUBPANEL_BACKGROUND_COLOR;
    public static final Color SUBPANEL_TITLE_COLOR;
    public static final Color SUBPANEL_CONTROL_COLOR;
    public static final DoubleRange ELEVATION_AXIS_RANGE;

    static {
        ZOOMED_CANVAS_COLOR = BIRDS_EYE_CANVAS_COLOR = new Color(99, 173, 255);
        ICE_SURFACE_ABOVE_ELA_COLOR = Color.WHITE;
        ICE_SURFACE_BELOW_ELA_COLOR = new Color(217, 217, 217);
        ICE_CROSS_SECTION_COLOR = new Color(207, 255, 255);
        SNOW_PATCH_SURFACE_COLOR = ICE_SURFACE_ABOVE_ELA_COLOR;
        SNOW_PATCH_CROSS_SECTION_COLOR = Color.LIGHT_GRAY;
        RIPPLE_ABOVE_ELA_COLOR = ICE_SURFACE_ABOVE_ELA_COLOR.darker();
        RIPPLE_BELOW_ELA_COLOR = ICE_SURFACE_BELOW_ELA_COLOR.darker();
        DEBRIS_COLOR = Color.BLACK;
        UNDERGROUND_COLOR = new Color(180, 158, 134);
        CONTROL_PANEL_BACKGROUND_COLOR = new Color(219, 255, 224);
        GLACIAL_BUDGET_COLOR = Color.RED;
        ACCUMULATION_COLOR = Color.BLUE;
        ABLATION_COLOR = Color.GREEN.darker();
        NEGATIVE_ABLATION_COLOR = Color.GREEN.darker();
        SUBPANEL_TITLE_FONT = new PhetFont(1, 12);
        SUBPANEL_CONTROL_FONT = new PhetFont(0, 12);
        SUBPANEL_BACKGROUND_COLOR = new Color(82, 126, 90);
        SUBPANEL_TITLE_COLOR = Color.WHITE;
        SUBPANEL_CONTROL_COLOR = Color.WHITE;
        ELEVATION_AXIS_RANGE = new DoubleRange(0.0, 7000.0);
    }
}

