/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.genenetwork.model.GeneNetworkModelAdapter;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import edu.colorado.phet.genenetwork.view.GeneNetworkFontFactory;
import edu.colorado.phet.genenetwork.view.SimpleModelElementNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Font;
import java.awt.geom.Point2D;

public abstract class ToolBoxItemNode
extends PComposite {
    protected static final ModelViewTransform2D SCALING_MVT = new ModelViewTransform2D((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point2D.Double(0.0, 0.0), 6.0, true);
    private static final Font LABEL_FONT = GeneNetworkFontFactory.getFont(16, 1);
    private final IGeneNetworkModelControl model;
    private SimpleModelElementNode selectionNode = null;
    private HTMLNode caption = null;
    private SimpleModelElement modelElement = null;
    private CursorHandler cursorHandler = new CursorHandler(12);

    public ToolBoxItemNode(IGeneNetworkModelControl iGeneNetworkModelControl, final ModelViewTransform2D modelViewTransform2D, final PhetPCanvas phetPCanvas) {
        this.model = iGeneNetworkModelControl;
        this.initializeSelectionNode();
        this.updateLayout();
        this.addInputEventListener(this.cursorHandler);
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                Point2D point2D = pInputEvent.getCanvasPosition();
                Point2D.Double double_ = new Point2D.Double(point2D.getX(), point2D.getY());
                phetPCanvas.getPhetRootNode().screenToWorld(double_);
                Point2D point2D2 = modelViewTransform2D.viewToModel(double_);
                if (ToolBoxItemNode.this.modelElement == null) {
                    if (ToolBoxItemNode.this.okToAddElement()) {
                        ToolBoxItemNode.this.handleAddRequest(point2D);
                        ToolBoxItemNode.this.modelElement.setDragging(true);
                        ToolBoxItemNode.this.modelElement.setPosition(point2D2);
                    }
                } else {
                    System.out.println(this.getClass().getName() + " - Warning: Mouse press event received but element already exists.");
                    assert (false);
                }
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                Point2D point2D = pInputEvent.getCanvasPosition();
                Point2D.Double double_ = new Point2D.Double(point2D.getX(), point2D.getY());
                phetPCanvas.getPhetRootNode().screenToWorld(double_);
                Point2D point2D2 = modelViewTransform2D.viewToModel(double_);
                if (ToolBoxItemNode.this.modelElement != null) {
                    ToolBoxItemNode.this.modelElement.setPosition(point2D2);
                }
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                Point2D point2D = pInputEvent.getCanvasPosition();
                Point2D.Double double_ = new Point2D.Double(point2D.getX(), point2D.getY());
                phetPCanvas.getPhetRootNode().screenToWorld(double_);
                if (ToolBoxItemNode.this.modelElement != null) {
                    ToolBoxItemNode.this.modelElement.setDragging(false);
                    ToolBoxItemNode.this.modelElement = null;
                }
            }
        });
        iGeneNetworkModelControl.addListener(new GeneNetworkModelAdapter(){

            public void modelElementAdded(SimpleModelElement simpleModelElement) {
                ToolBoxItemNode.this.handleModelElementAdded(simpleModelElement);
            }
        });
    }

    protected abstract void initializeSelectionNode();

    protected abstract void handleAddRequest(Point2D var1);

    protected abstract boolean okToAddElement();

    protected void handleModelElementAdded(SimpleModelElement simpleModelElement) {
    }

    protected void setSelectionNode(SimpleModelElementNode simpleModelElementNode) {
        assert (this.selectionNode == null);
        this.selectionNode = simpleModelElementNode;
        this.addChild(simpleModelElementNode);
    }

    protected void setModelElement(SimpleModelElement simpleModelElement) {
        assert (this.modelElement == null);
        this.modelElement = simpleModelElement;
    }

    protected SimpleModelElementNode getSelectionNode() {
        return this.selectionNode;
    }

    protected void setCaption(String string) {
        this.caption = new HTMLNode(string);
        this.caption.setFont(LABEL_FONT);
        this.addChild(this.caption);
    }

    private void updateLayout() {
        if (this.caption != null && this.selectionNode != null) {
            this.caption.setOffset(-this.caption.getFullBoundsReference().getWidth() / 2.0, this.selectionNode.getFullBoundsReference().getMaxY() + 4.0);
        }
    }

    protected IGeneNetworkModelControl getModel() {
        return this.model;
    }
}

