/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.view;

import edu.colorado.phet.genenetwork.GeneNetworkStrings;
import edu.colorado.phet.genenetwork.model.LacOperonModel;
import edu.colorado.phet.genenetwork.view.BasicDnaSegmentToolBoxNode;
import edu.colorado.phet.genenetwork.view.DnaStrandNode;
import edu.colorado.phet.genenetwork.view.GeneNetworkCanvas;
import edu.colorado.phet.genenetwork.view.LactoseInjectorNode;
import edu.colorado.phet.genenetwork.view.LactoseMeter;
import edu.colorado.phet.genenetwork.view.MacroMoleculeLegend;

public class LactoseRegulationCanvas
extends GeneNetworkCanvas {
    public LactoseRegulationCanvas(LacOperonModel lacOperonModel) {
        super(lacOperonModel);
        this.setDnaStrand(new DnaStrandNode(lacOperonModel.getDnaStrand(), this.getMvt(), this.getBackground()));
        this.setToolBox(new BasicDnaSegmentToolBoxNode(this, lacOperonModel, this.getMvt()));
        LactoseInjectorNode lactoseInjectorNode = new LactoseInjectorNode(lacOperonModel, this.getMvt(), -0.5235987755982988, GeneNetworkStrings.LACTOSE_INJECTOR_LABEL);
        lactoseInjectorNode.setOffset(50.0, 120.0);
        this.setLactoseInjector(lactoseInjectorNode);
        this.setLegend(new MacroMoleculeLegend(lacOperonModel, this));
        LactoseMeter lactoseMeter = new LactoseMeter(lacOperonModel);
        lactoseMeter.setOffset(-200.0, 250.0);
        this.setLactoseMeter(lactoseMeter);
    }
}

