/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.view;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.genenetwork.GeneNetworkResources;
import edu.colorado.phet.genenetwork.GeneNetworkStrings;
import edu.colorado.phet.genenetwork.model.GeneNetworkModelAdapter;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.Timer;

public class LactoseInjectorNode
extends PNode {
    private static final Point2D BUTTON_OFFSET = new Point2D.Double(-100.0, -65.0);
    private static double NOMINAL_LACTOSE_INJECTION_VELOCITY = 20.0;
    private static final Random RAND = new Random();
    double rotationAngle;
    private final PNode injectorBodyImageNode;
    private final PNode unpressedButtonImageNode;
    private final PNode pressedButtonImageNode;
    private final PNode autoInjectionControl;
    private final PNode injectorNode;
    private final IGeneNetworkModelControl model;
    private final ModelViewTransform2D mvt;
    private final Point2D injectionPoint = new Point2D.Double();
    private float transparency;
    private final Point2D injectionPointInModelCoords = new Point2D.Double();
    private final Vector2D nominalInjectionVelocityVector = new Vector2D(NOMINAL_LACTOSE_INJECTION_VELOCITY, 0.0);
    private final Timer fadeInTimer = new Timer(40, null);

    public LactoseInjectorNode(IGeneNetworkModelControl iGeneNetworkModelControl, ModelViewTransform2D modelViewTransform2D, double d, String string) {
        this.model = iGeneNetworkModelControl;
        this.mvt = modelViewTransform2D;
        this.rotationAngle = d;
        this.nominalInjectionVelocityVector.rotate(d);
        this.injectorNode = new PNode();
        BufferedImage bufferedImage = GeneNetworkResources.getImage("squeezer_background.png");
        this.injectorBodyImageNode = new PImage(bufferedImage);
        PBounds pBounds = this.injectorBodyImageNode.getFullBounds();
        this.injectorBodyImageNode.setOffset(-((RectangularShape)pBounds).getWidth() / 2.0, -((RectangularShape)pBounds).getHeight() / 2.0);
        this.injectorNode.addChild(this.injectorBodyImageNode);
        BufferedImage bufferedImage2 = GeneNetworkResources.getImage("button_pressed.png");
        this.pressedButtonImageNode = new PImage(bufferedImage2);
        this.pressedButtonImageNode.setOffset(BUTTON_OFFSET);
        this.injectorNode.addChild(this.pressedButtonImageNode);
        BufferedImage bufferedImage3 = GeneNetworkResources.getImage("button_unpressed.png");
        this.unpressedButtonImageNode = new PImage(bufferedImage3);
        this.unpressedButtonImageNode.setOffset(BUTTON_OFFSET);
        this.injectorNode.addChild(this.unpressedButtonImageNode);
        double d2 = 130.0 / this.injectorBodyImageNode.getFullBoundsReference().height;
        this.injectorNode.rotate(-d);
        this.injectorNode.scale(d2);
        this.autoInjectionControl = new AutomaticInjectionSelector(iGeneNetworkModelControl, 117.0, 91.0);
        this.autoInjectionControl.setOffset(this.injectorNode.getFullBoundsReference().getMinX() - this.autoInjectionControl.getFullBoundsReference().width + 5.0, this.injectorNode.getFullBoundsReference().getCenterY() - this.autoInjectionControl.getFullBoundsReference().height / 2.0);
        this.addChild(this.autoInjectionControl);
        this.injectorNode.setOffset(-Math.abs(Math.sin(d * 2.0)) * 30.0, 0.0);
        this.addChild(this.injectorNode);
        this.updateInjectionPoint();
        iGeneNetworkModelControl.setAutomaticLactoseInjectionParams(this.injectionPointInModelCoords, this.nominalInjectionVelocityVector);
        if (string != null) {
            PDimension pDimension = new PDimension(this.getFullBoundsReference().width * 0.6, this.getFullBoundsReference().getHeight() * 0.2);
            PText pText = new PText(string);
            pText.setFont(new PhetFont());
            double d3 = Math.min(((Dimension2D)pDimension).getWidth() / pText.getWidth(), ((Dimension2D)pDimension).getHeight() / pText.getHeight());
            pText.setScale(d3);
            pText.setOffset(this.getFullBoundsReference().getCenterX() - this.getFullBoundsReference().getWidth() * 0.1 - pText.getFullBoundsReference().width / 2.0, this.getFullBoundsReference().getMinY() - pText.getFullBoundsReference().height + Math.sin(Math.abs(d * 2.0)) * pText.getFullBoundsReference().height * 0.9);
            this.addChild(pText);
        }
        this.unpressedButtonImageNode.setPickable(true);
        this.pressedButtonImageNode.setPickable(false);
        this.injectorBodyImageNode.setPickable(false);
        this.unpressedButtonImageNode.addInputEventListener(new CursorHandler());
        this.pressedButtonImageNode.addInputEventListener(new CursorHandler());
        this.unpressedButtonImageNode.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                LactoseInjectorNode.this.unpressedButtonImageNode.setVisible(false);
                LactoseInjectorNode.this.injectLactose();
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                LactoseInjectorNode.this.unpressedButtonImageNode.setVisible(true);
            }
        });
        iGeneNetworkModelControl.addListener(new GeneNetworkModelAdapter(){

            public void lactoseInjectionAllowedStateChange() {
                LactoseInjectorNode.this.updateInjectorNodeVisibility();
                LactoseInjectorNode.this.updateInjectButtonVisibility();
            }

            public void automaticLactoseInjectionEnabledStateChange() {
                LactoseInjectorNode.this.updateInjectButtonVisibility();
            }
        });
        this.fadeInTimer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LactoseInjectorNode.this.transparency = Math.min(1.0f, LactoseInjectorNode.this.transparency + 0.05f);
                LactoseInjectorNode.this.setTransparency(LactoseInjectorNode.this.transparency);
                if (LactoseInjectorNode.this.transparency >= 1.0f) {
                    LactoseInjectorNode.this.fadeInTimer.stop();
                }
            }
        });
        this.updateInjectorNodeVisibility();
        this.updateInjectButtonVisibility();
    }

    public LactoseInjectorNode(IGeneNetworkModelControl iGeneNetworkModelControl, ModelViewTransform2D modelViewTransform2D, double d) {
        this(iGeneNetworkModelControl, modelViewTransform2D, d, null);
    }

    public void setOffset(double d, double d2) {
        super.setOffset(d, d2);
        this.updateInjectionPoint();
        this.model.setAutomaticLactoseInjectionParams(this.injectionPointInModelCoords, this.nominalInjectionVelocityVector);
    }

    private void injectLactose() {
        Vector2D vector2D = new Vector2D(this.nominalInjectionVelocityVector);
        vector2D.rotate((RAND.nextDouble() - 0.5) * Math.PI * 0.15);
        this.model.createAndAddLactose(this.injectionPointInModelCoords, vector2D);
    }

    private void updateInjectorNodeVisibility() {
        if (this.model.isLactoseInjectionAllowed()) {
            this.setVisible(true);
            this.fadeInTimer.start();
        } else {
            this.setVisible(false);
            this.transparency = 0.0f;
            this.setTransparency(this.transparency);
        }
    }

    private void updateInjectButtonVisibility() {
        boolean bl = this.model.isLactoseInjectionAllowed();
        boolean bl2 = this.model.isAutomaticLactoseInjectionEnabled();
        this.unpressedButtonImageNode.setVisible(bl && !bl2);
        this.unpressedButtonImageNode.setPickable(bl && !bl2);
        this.pressedButtonImageNode.setVisible(bl && !bl2);
    }

    private void updateInjectionPoint() {
        double d = 91.0;
        Point2D point2D = this.injectorNode.getFullBoundsReference().getCenter2D();
        this.injectionPoint.setLocation(d * Math.cos(this.rotationAngle) + point2D.getX(), d * Math.sin(-this.rotationAngle) + point2D.getY());
        Point2D point2D2 = this.localToGlobal(new Point2D.Double(this.injectionPoint.getX(), this.injectionPoint.getY()));
        this.injectionPointInModelCoords.setLocation(this.mvt.viewToModel(point2D2));
    }

    private static class AutomaticInjectionSelector
    extends PNode {
        private static final Font AUTO_INJECT_CTRL_LABEL_FONT = new PhetFont(14);
        private static final Color BACKGROUND_COLOR = new Color(248, 236, 84);
        private static final Stroke BORDER_STROKE = new BasicStroke(2.0f);
        private static final Stroke CONNECTOR_STROKE = new BasicStroke(8.0f);
        private final IGeneNetworkModelControl model;
        private final JRadioButton manualButton;
        private final JRadioButton autoButton;

        public AutomaticInjectionSelector(final IGeneNetworkModelControl iGeneNetworkModelControl, double d, double d2) {
            this.model = iGeneNetworkModelControl;
            this.manualButton = new JRadioButton(GeneNetworkStrings.MANUAL_LACTOSE_INJECTION_LABEL);
            this.manualButton.setBackground(BACKGROUND_COLOR);
            this.manualButton.setFont(AUTO_INJECT_CTRL_LABEL_FONT);
            this.manualButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    iGeneNetworkModelControl.setAutomaticLactoseInjectionEnabled(false);
                }
            });
            this.autoButton = new JRadioButton(GeneNetworkStrings.AUTO_LACTOSE_INJECTION_LABEL);
            this.autoButton.setBackground(BACKGROUND_COLOR);
            this.autoButton.setFont(AUTO_INJECT_CTRL_LABEL_FONT);
            this.autoButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    iGeneNetworkModelControl.setAutomaticLactoseInjectionEnabled(true);
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.manualButton);
            buttonGroup.add(this.autoButton);
            this.updateButtonState();
            iGeneNetworkModelControl.addListener(new GeneNetworkModelAdapter(){

                public void automaticLactoseInjectionEnabledStateChange() {
                    AutomaticInjectionSelector.this.updateButtonState();
                }
            });
            VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
            verticalLayoutPanel.setBackground(BACKGROUND_COLOR);
            ((Container)verticalLayoutPanel).add(this.manualButton);
            ((Container)verticalLayoutPanel).add(this.autoButton);
            PSwing pSwing = new PSwing(verticalLayoutPanel);
            PBounds pBounds = pSwing.getFullBoundsReference();
            double d3 = Math.min((d - 8.0) / pBounds.getWidth(), (d2 - 8.0) / pBounds.getHeight());
            pSwing.setScale(d3);
            PhetPPath phetPPath = new PhetPPath(new RoundRectangle2D.Double(0.0, 0.0, d, d2, 7.0, 7.0), BACKGROUND_COLOR, BORDER_STROKE, Color.black);
            phetPPath.addChild(pSwing);
            pSwing.setOffset(d / 2.0 - pSwing.getFullBoundsReference().width / 2.0, d2 / 2.0 - pSwing.getFullBoundsReference().height / 2.0);
            PhetPPath phetPPath2 = new PhetPPath(new Line2D.Double(0.0, 0.0, 20.0, 0.0), CONNECTOR_STROKE, (Paint)Color.BLACK);
            this.addChild(phetPPath2);
            this.addChild(phetPPath);
            phetPPath2.setOffset(phetPPath.getFullBoundsReference().width, phetPPath.getFullBoundsReference().height / 2.0);
        }

        private void updateButtonState() {
            this.manualButton.setSelected(!this.model.isAutomaticLactoseInjectionEnabled());
            this.autoButton.setSelected(this.model.isAutomaticLactoseInjectionEnabled());
        }
    }
}

