/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.genenetwork.model.DnaStrand;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class DnaStrandNode
extends PNode {
    public static Color STRAND_1_COLOR = new Color(31, 163, 223);
    public static Color STRAND_2_COLOR = new Color(214, 87, 107);
    private static final Stroke STRAND_STROKE = new BasicStroke(2.0f);
    private DnaStrand dnaStrand;
    private PPath boundsRectNode;
    private PPath strand1Node;
    private PPath strand2Node;
    private ModelViewTransform2D mvt;

    public DnaStrandNode(DnaStrand dnaStrand, ModelViewTransform2D modelViewTransform2D, Color color) {
        this.dnaStrand = dnaStrand;
        this.mvt = modelViewTransform2D;
        this.strand1Node = new PhetPPath(STRAND_STROKE, (Paint)STRAND_1_COLOR);
        this.addChild(this.strand1Node);
        this.strand2Node = new PhetPPath(STRAND_STROKE, (Paint)STRAND_2_COLOR);
        this.addChild(this.strand2Node);
        this.updateStrandShapes();
        Shape shape = modelViewTransform2D.createTransformedShape(this.getFullBoundsReference().getBounds2D());
        this.boundsRectNode = new PhetPPath(shape, (Stroke)new BasicStroke(1.0f), (Paint)Color.RED);
        this.addChild(this.boundsRectNode);
        for (DnaStrand.DnaSegmentSpace dnaSegmentSpace : dnaStrand.getDnaSegmentSpaces()) {
            this.addChild(new DnaSegementSpaceNode(dnaSegmentSpace, modelViewTransform2D, color));
        }
        this.updateOffset();
    }

    private void updateStrandShapes() {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(this.mvt.getAffineTransform().getScaleX(), this.mvt.getAffineTransform().getScaleY());
        Shape shape = affineTransform.createTransformedShape(this.dnaStrand.getStrand1Shape());
        this.strand1Node.setPathTo(shape);
        shape = affineTransform.createTransformedShape(this.dnaStrand.getStrand2Shape());
        this.strand2Node.setPathTo(shape);
    }

    private void updateOffset() {
        this.setOffset(this.mvt.modelToView(this.dnaStrand.getPositionRef()));
    }

    private static class DnaSegementSpaceNode
    extends PPath {
        private static final Stroke OUTLINE_STROKE = new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{8.0f, 5.0f}, 0.0f);
        private static final Color EYE_CATCHING_COLOR = Color.YELLOW;
        private DnaStrand.DnaSegmentSpace dnaSegmentSpace;
        private Color nonEyeCatchingColor;

        public DnaSegementSpaceNode(DnaStrand.DnaSegmentSpace dnaSegmentSpace, ModelViewTransform2D modelViewTransform2D, Color color) {
            this.nonEyeCatchingColor = color;
            this.dnaSegmentSpace = dnaSegmentSpace;
            this.setStroke(OUTLINE_STROKE);
            this.setStrokePaint(Color.BLACK);
            AffineTransform affineTransform = AffineTransform.getScaleInstance(modelViewTransform2D.getAffineTransform().getScaleX(), modelViewTransform2D.getAffineTransform().getScaleY());
            Shape shape = affineTransform.createTransformedShape(dnaSegmentSpace);
            this.setPathTo(shape);
            this.setOffset(affineTransform.transform(dnaSegmentSpace.getOffsetFromDnaStrandPosRef(), null));
            dnaSegmentSpace.addListener(new DnaStrand.DnaSegmentSpace.Listener(){

                public void eyeCatchingStateChange() {
                    DnaSegementSpaceNode.this.updateEyeCatching();
                }

                public void occupiedStateChange() {
                    DnaSegementSpaceNode.this.updateOccupied();
                }
            });
            this.updateEyeCatching();
            this.updateOccupied();
        }

        private void updateEyeCatching() {
            if (this.dnaSegmentSpace.isEyeCatching()) {
                this.setPaint(EYE_CATCHING_COLOR);
            } else {
                this.setPaint(this.nonEyeCatchingColor);
            }
        }

        private void updateOccupied() {
            this.setVisible(!this.dnaSegmentSpace.isOccupied());
        }
    }
}

